/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VerificationTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("verification", "queryService")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.goros.egeasy.driver.model.SVD.TGSVDRequest;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.HashMap;\nimport java.util.Map;\n\npublic class QueryServiceTemplate extends AbstractQueryServiceTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGSVDRequest request;\n    private final Map<String, String> values = new HashMap<>();\n\n    public QueryServiceTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public TGSVDRequest request() {\n        return serviceToggle.state() == ToggleEvent.State.Off ? null : buildRequest();\n    }\n\n    private TGSVDRequest buildRequest() {\n        TGSVDRequest result = new TGSVDRequest();\n        result.setService(request.getService());\n        result.setSpecificData(new HashMap<>(values));\n        return result;\n    }\n\n    public void request(TGSVDRequest request) {\n        this.request = request;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        serviceToggle.onToggle(e -> toggleParamsBlock());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        serviceToggle.title(request.getService());\n        serviceToggle.state(ToggleEvent.State.Off);\n        params.clear();\n        values.clear();\n        request.getSpecificData().forEach((key, value) -> fill(key, value, params.add()));\n    }\n\n    private void fill(String key, String value, QueryServiceParamTemplate display) {\n        values.put(key, value);\n        display.key(key);\n        display.value(value);\n        display.onChange(e -> values.put(key, e));\n        display.refresh();\n    }\n\n    private void toggleParamsBlock() {\n        paramsBlock.visible(serviceToggle.state() == ToggleEvent.State.On);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("verification", "queryServiceParam")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class QueryServiceParamTemplate extends AbstractQueryServiceParamTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private String _name;\n    private String _value;\n    private Consumer<String> changeListener;\n\n    public QueryServiceParamTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void key(String value) {\n        this._name = value;\n    }\n\n    public void value(String value) {\n        this._value = value;\n    }\n\n    public void onChange(Consumer<String> listener) {\n        this.changeListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        value.onChange(e -> changeListener.accept(e.value()));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        name.value(_name);\n        value.value(_value);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("verification")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.MimeTypes;\nimport io.intino.alexandria.ui.File;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.goros.egeasy.box.generators.VerificationGenerator;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.util.FileHelper;\nimport io.intino.goros.egeasy.driver.model.SVD.TGSVDQuery;\nimport io.intino.goros.egeasy.driver.model.SVD.TGSVDRequest;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.Objects;\nimport java.util.stream.Collectors;\n\npublic class VerificationTemplate extends AbstractVerificationTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGResource container;\n    private String selectedConsulta;\n    private final List<QueryServiceTemplate> newServicesDisplays = new ArrayList<>();\n\n    public VerificationTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void entity(TGResource container) {\n        this.container = container;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        newQueryDialog.onOpen(e -> refreshNewQueryDialog());\n        refresh.onExecute(e -> refresh());\n        print.onExecute(e -> viewer.print(container.getName()));\n        executeQuery.onExecute(e -> executeQuery());\n        queryDetailsDialog.onOpen(e -> refreshQueryDetailsDialog());\n        viewer.on(\"copyValueToClipboard\", params -> copyToClipboard(params.get(0)));\n        viewer.on(\"openNotificationDocument\", params -> openNotificationDocument(params.get(0)));\n        viewer.on(\"openQueryDetailsDialog\", params -> openQueryDetailsDialog(params.get(0)));\n        viewer.on(\"openNewQueryDialog\", params -> openNewQueryDialog());\n    }\n\n    public void refresh() {\n        viewer.content(new VerificationGenerator(box().provider(session())).generate(container));\n        viewer.refresh();\n    }\n\n    private void copyToClipboard(String content) {\n        copyLink.text(content);\n        copyLink.launch();\n    }\n\n    private void openNotificationDocument(String label) {\n        notifyUser(\"Abrir el documento de notificaci\u00f3n \" + label, UserMessage.Type.Info);\n    }\n\n    private void openQueryDetailsDialog(String id) {\n        this.selectedConsulta = id;\n        queryDetailsDialog.open();\n    }\n\n    private void refreshQueryDetailsDialog() {\n        TGSVDQuery query = box().provider(session()).openSVDQuery(container.getUEL(), container.getDRC(), Integer.parseInt(selectedConsulta));\n        queryDetailsDialog.title(String.format(\"Detalles de %s\", query.getName()));\n        dateField.value(query.getDate().toInstant());\n        stateField.value(query.getState().name());\n        requestorField.value(query.getRequestor());\n        io.intino.goros.egeasy.m3.file.File receipt = query.getReceipt();\n        justificante.value(new File().filename(receipt.getFilename()).value(FileHelper.urlOf(container.getERC(), container.getDRC(), receipt.getComponentDrc(), receipt.getComponentRow(), receipt.getFileId(), receipt.getType(), receipt.getFilename(), false, session())).mimeType(MimeTypes.contentTypeOf(DisplayHelper.extensionOf(receipt.getFilename()))));\n    }\n\n    private void openNewQueryDialog() {\n        newQueryDialog.open();\n    }\n\n    private void refreshNewQueryDialog() {\n        List<TGSVDRequest> requests = box().provider(session()).getSVDRequests((TGContainer) container);\n        noRequestsBlock.visible(requests.isEmpty());\n        requestsBlock.visible(!requests.isEmpty());\n        if (requests.isEmpty()) return;\n        TGSVDRequest request = requests.get(0);\n        newRequestorField.value(request.getRequestor());\n        newUnitField.value(request.getUnit());\n        newExpNumberField.value(request.getExpNumber());\n        newPurposeField.value(request.getPurpose());\n        newConsentField.state(request.getConsent() ? ToggleEvent.State.On : ToggleEvent.State.Off);\n        refreshNewQueryServices(requests);\n    }\n\n    private void refreshNewQueryServices(List<TGSVDRequest> requests) {\n        newServices.clear();\n        newServicesDisplays.clear();\n        requests.forEach(r -> fill(r, newServices.add()));\n    }\n\n    private void fill(TGSVDRequest request, QueryServiceTemplate display) {\n        newServicesDisplays.add(display);\n        display.request(request);\n        display.refresh();\n    }\n\n    private void executeQuery() {\n        List<TGSVDRequest> requests = newServicesDisplays.stream().map(QueryServiceTemplate::request).filter(Objects::nonNull).collect(Collectors.toList());\n        if (requests.isEmpty()) {\n            notifyUser(\"Debe seleccionar al menos un servicio al cual consultar\", UserMessage.Type.Warning);\n            return;\n        }\n        newQueryDialog.close();\n        requests.forEach(this::executeQueryRequest);\n        hideUserNotification();\n        refresh();\n    }\n\n    private void executeQueryRequest(TGSVDRequest request) {\n        notifyUser(\"Ejecutando consulta a \" + request.getService(), UserMessage.Type.Loading);\n        box().provider(session()).executeSVDRequest(container.getUEL(), container.getDRC(), withCommonParameters(request));\n    }\n\n    private TGSVDRequest withCommonParameters(TGSVDRequest request) {\n        request.setUnit(newUnitField.value());\n        request.setRequestor(newRequestorField.value());\n        request.setExpNumber(newExpNumberField.value());\n        request.setPurpose(newPurposeField.value());\n        request.setConsent(newConsentField.state() == ToggleEvent.State.On);\n        return request;\n    }\n\n}")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

