/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.utils;

import java.time.Instant;

public class DateUtils {
    private static final double NULL_DATE = 0.0;
    private static final int MILISECONDS_PER_DAY = 86400000;

    public static Instant doubleToInstant(Double value) {
        if (value == 0.0) {
            return null;
        }
        Double days = Math.floor(value);
        double partOfDay = value - days;
        return Instant.ofEpochMilli(days.longValue() * 86400000L + (long)((int)Math.round(partOfDay * 8.64E7)) + DateUtils.delphiReference().toEpochMilli());
    }

    public static Double instantToDouble(Instant value) {
        if (value == null) {
            return 0.0;
        }
        long timeDiff = value.toEpochMilli() - DateUtils.delphiReference().toEpochMilli();
        long days = timeDiff / 86400000L;
        return (double)days + (double)(timeDiff %= 86400000L) / 8.64E7;
    }

    public static Instant delphiReference() {
        return Instant.parse("1899-11-30T00:00:00Z");
    }
}

