/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.model;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.entity.resource.TGResource;
import java.util.ArrayList;
import java.util.List;

public class TreeNodeResource {
    private String label;
    private TGResource res = null;
    private List<TreeNodeResource> childrens = new ArrayList<TreeNodeResource>();
    private TreeNodeResource parent = null;
    private List<Definition> definitions = null;

    public void addChildren(TreeNodeResource nodeResource) {
        if (this.childrens.contains(nodeResource)) {
            return;
        }
        nodeResource.setParent(this);
        this.childrens.add(nodeResource);
    }

    public TreeNodeResource addChildren(String label, TGResource res) {
        TreeNodeResource node = new TreeNodeResource();
        node.setLabel(label);
        node.setResource(res);
        node.setParent(this);
        this.childrens.add(node);
        return node;
    }

    public List<TreeNodeResource> getChildrens() {
        return this.childrens;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public TGResource getResource() {
        return this.res;
    }

    public void setResource(TGResource value) {
        this.res = value;
    }

    private void setParent(TreeNodeResource parent) {
        this.parent = parent;
    }

    public TreeNodeResource getParent() {
        return this.parent;
    }

    public List<Definition> getDefinitions() {
        if (this.definitions == null) {
            this.definitions = new ArrayList<Definition>();
            this.fillNodeDefinitions(this.definitions, this);
        }
        return this.definitions;
    }

    private void fillNodeDefinitions(List<Definition> definitions, TreeNodeResource node) {
        Definition definition;
        Definition definition2 = definition = node.getResource() != null ? node.getResource().getDefinition() : null;
        if (definition != null && !definitions.contains(definition)) {
            definitions.add(definition);
        }
        for (TreeNodeResource nodeChildren : node.childrens) {
            this.fillNodeDefinitions(definitions, nodeChildren);
        }
    }

    public TreeNodeResource findChildren(String label) {
        for (TreeNodeResource node : this.childrens) {
            if (!node.getLabel().equals(label)) continue;
            return node;
        }
        return null;
    }
}

