/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.library;

import io.intino.goros.egeasy.m3.entity.TGVariant;
import io.intino.goros.egeasy.m3.utils.DateUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class LibraryStream {
    private static final String CURRENCY_SEPARATOR = ":";
    private static final long MILISECONDS_PER_DAY = 86400000L;
    private static final long NANOSECONDS_PER_SECOND = 1000000L;

    private static byte[] invert(byte[] b) {
        int l = b.length;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            result[i] = b[l - i - 1];
        }
        return result;
    }

    public static byte[] intToByteArrayLittleEndian(int value) {
        byte[] conv = new byte[4];
        conv[3] = (byte)(value & 0xFF);
        conv[2] = (byte)((value >>= 8) & 0xFF);
        conv[1] = (byte)((value >>= 8) & 0xFF);
        conv[0] = (byte)(value >>= 8);
        return conv;
    }

    private static byte[] intToByteArrayBigEndian(int value) {
        byte[] conv = new byte[]{(byte)(value & 0xFF), (byte)((value >>= 8) & 0xFF), (byte)((value >>= 8) & 0xFF), (byte)(value >>= 8)};
        return conv;
    }

    private static int byteArrayToIntBigEndian(byte[] b) {
        int value = b[3] & 0xFF;
        value <<= 8;
        value += b[2] & 0xFF;
        value <<= 8;
        value += b[1] & 0xFF;
        value <<= 8;
        return value += b[0] & 0xFF;
    }

    private static byte[] longToByteArrayBigEndian(long value) {
        byte[] conv = new byte[]{(byte)(value & 0xFFL), (byte)((value >>= 8) & 0xFFL), (byte)((value >>= 8) & 0xFFL), (byte)((value >>= 8) & 0xFFL), (byte)((value >>= 8) & 0xFFL), (byte)((value >>= 8) & 0xFFL), (byte)((value >>= 8) & 0xFFL), (byte)(value >>= 8)};
        return conv;
    }

    private static long byteArrayToLongBigEndian(byte[] b) {
        long value = b[7] & 0xFF;
        value <<= 8;
        value += (long)(b[6] & 0xFF);
        value <<= 8;
        value += (long)(b[5] & 0xFF);
        value <<= 8;
        value += (long)(b[4] & 0xFF);
        value <<= 8;
        value += (long)(b[3] & 0xFF);
        value <<= 8;
        value += (long)(b[2] & 0xFF);
        value <<= 8;
        value += (long)(b[1] & 0xFF);
        value <<= 8;
        return value += (long)(b[0] & 0xFF);
    }

    private static void readFully(InputStream stream, byte[] b) throws IOException {
        int count;
        int len = b.length;
        for (int n = 0; n < len; n += count) {
            count = stream.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static byte readByte(InputStream stream) throws IOException {
        byte[] b = new byte[1];
        stream.read(b);
        return b[0];
    }

    public static int readUnsignedByte(InputStream stream) throws IOException {
        byte[] b = new byte[1];
        stream.read(b);
        byte i = b[0];
        return i & 0xFF;
    }

    public static Boolean readBoolean(InputStream stream) throws IOException {
        byte[] b = new byte[1];
        stream.read(b);
        return b[0] == 1;
    }

    public static int readInt(InputStream stream) throws IOException {
        byte[] b = new byte[4];
        LibraryStream.readFully(stream, b);
        return LibraryStream.byteArrayToIntBigEndian(b);
    }

    public static long readLong(InputStream stream) throws IOException {
        byte[] b = new byte[8];
        LibraryStream.readFully(stream, b);
        return LibraryStream.byteArrayToLongBigEndian(b);
    }

    public static float readSingle(InputStream stream) throws IOException {
        byte[] b = new byte[4];
        LibraryStream.readFully(stream, b);
        b = LibraryStream.invert(b);
        return ByteBuffer.wrap(b).getFloat();
    }

    public static double readDouble(InputStream stream) throws IOException {
        byte[] b = new byte[8];
        LibraryStream.readFully(stream, b);
        b = LibraryStream.invert(b);
        return ByteBuffer.wrap(b).getDouble();
    }

    public static String readString(InputStream stream, boolean wide) throws IOException {
        if (wide) {
            return LibraryStream.readStringWS(stream);
        }
        return LibraryStream.readString(stream);
    }

    private static String readString(InputStream stream) throws IOException {
        Integer l = LibraryStream.readInt(stream);
        byte[] buffer = new byte[l.intValue()];
        LibraryStream.readFully(stream, buffer);
        return new String(buffer, "ISO-8859-1").replaceAll("\r\n", "\n");
    }

    private static String readStringWS(InputStream stream) throws IOException {
        Integer l = LibraryStream.readInt(stream);
        if (l == 0) {
            return "";
        }
        byte[] buffer = new byte[l * 2];
        LibraryStream.readFully(stream, buffer);
        return new String(buffer, "UTF_16LE").replaceAll("\r\n", "\n");
    }

    public static ZonedDateTime readDateTime(InputStream stream) throws IOException {
        byte[] b = new byte[8];
        stream.read(b);
        b = LibraryStream.invert(b);
        double d = ByteBuffer.wrap(b).getDouble();
        Instant instant = DateUtils.doubleToInstant(d);
        return instant != null ? instant.atZone(ZoneId.systemDefault()) : null;
    }

    public static TGVariant readVariant(InputStream stream) throws IOException {
        int type = LibraryStream.readInt(stream);
        return LibraryStream.readVariant(stream, type);
    }

    public static TGVariant readVariant(InputStream stream, Integer type) throws IOException {
        switch (type) {
            case 0: 
            case 1: {
                return new TGVariant();
            }
            case 3: 
            case 16: 
            case 20: {
                return new TGVariant(type, LibraryStream.readInt(stream));
            }
            case 4: {
                return new TGVariant(type, Float.valueOf(LibraryStream.readSingle(stream)));
            }
            case 5: {
                return new TGVariant(type, LibraryStream.readDouble(stream));
            }
            case 7: {
                return new TGVariant(type, LibraryStream.readDouble(stream));
            }
            case 6: {
                return new TGVariant(type, LibraryStream.readLong(stream));
            }
            case 11: {
                return new TGVariant(type, LibraryStream.readBoolean(stream));
            }
            case 17: {
                return new TGVariant(type, LibraryStream.readByte(stream));
            }
            case 8: 
            case 256: {
                return new TGVariant(type, LibraryStream.readString(stream));
            }
            case 16385: {
                return new TGVariant(type, LibraryStream.readStringWS(stream));
            }
        }
        return new TGVariant(0, null);
    }

    public static byte[] readByteArray(InputStream stream) throws IOException {
        Integer l = LibraryStream.readInt(stream);
        byte[] buffer = new byte[l.intValue()];
        LibraryStream.readFully(stream, buffer);
        return buffer;
    }

    public static void writeByte(OutputStream stream, byte value) throws IOException {
        byte[] b = new byte[]{value};
        stream.write(b);
    }

    public static void writeBoolean(OutputStream stream, Boolean value) throws IOException {
        byte[] b = new byte[]{(byte)(value != false ? 1 : 0)};
        stream.write(b);
    }

    public static void writeInt(OutputStream stream, int value) throws IOException {
        stream.write(LibraryStream.intToByteArrayBigEndian(value));
    }

    public static void writeLong(OutputStream stream, long value) throws IOException {
        stream.write(LibraryStream.longToByteArrayBigEndian(value));
    }

    public static void writeSingle(OutputStream stream, float value) throws IOException {
        byte[] b = new byte[4];
        ByteBuffer.wrap(b).putFloat(value);
        b = LibraryStream.invert(b);
        stream.write(b);
    }

    public static void writeDouble(OutputStream stream, double value) throws IOException {
        byte[] b = new byte[8];
        ByteBuffer.wrap(b).putDouble(value);
        b = LibraryStream.invert(b);
        stream.write(b);
    }

    public static void writeString(OutputStream stream, String value, boolean wide) throws IOException {
        if (wide) {
            LibraryStream.writeStringWS(stream, value);
        } else {
            LibraryStream.writeString(stream, value);
        }
    }

    private static void writeString(OutputStream stream, String value) throws IOException {
        if (value == null) {
            LibraryStream.writeInt(stream, 0);
            return;
        }
        byte[] bytes = value.replaceAll("\n", "\r\n").getBytes(StandardCharsets.ISO_8859_1);
        LibraryStream.writeInt(stream, bytes.length);
        stream.write(bytes);
    }

    private static void writeStringWS(OutputStream stream, String value) throws IOException {
        if (value == null) {
            LibraryStream.writeInt(stream, 0);
            return;
        }
        String serialized = value.replaceAll("\n", "\r\n");
        byte[] bytes = serialized.getBytes(StandardCharsets.UTF_16LE);
        LibraryStream.writeInt(stream, serialized.length());
        stream.write(bytes);
    }

    public static void writeDateTime(OutputStream stream, ZonedDateTime value) throws IOException {
        double d = value != null ? DateUtils.instantToDouble(value.toInstant()) : 0.0;
        byte[] b = new byte[8];
        ByteBuffer.wrap(b).putDouble(d);
        b = LibraryStream.invert(b);
        stream.write(b);
    }

    public static void writeByteArray(OutputStream stream, byte[] value) throws IOException {
        if (value == null) {
            LibraryStream.writeInt(stream, 0);
            return;
        }
        LibraryStream.writeInt(stream, value.length);
        stream.write(value);
    }

    public static void writeVariant(OutputStream stream, TGVariant value) throws IOException, TGVariant.EGVariant {
        LibraryStream.writeInt(stream, value.getType());
        switch (value.getType()) {
            case 0: 
            case 1: {
                return;
            }
            case 3: 
            case 16: 
            case 20: {
                LibraryStream.writeInt(stream, value.asInt());
                return;
            }
            case 4: {
                LibraryStream.writeSingle(stream, value.asFloat().floatValue());
                return;
            }
            case 5: {
                LibraryStream.writeDouble(stream, value.asDouble());
                return;
            }
            case 7: {
                LibraryStream.writeDouble(stream, value.asDouble());
                return;
            }
            case 6: {
                LibraryStream.writeLong(stream, value.asLong());
                return;
            }
            case 11: {
                LibraryStream.writeBoolean(stream, value.asBoolean());
                return;
            }
            case 17: {
                LibraryStream.writeByte(stream, value.asByte());
                return;
            }
            case 8: 
            case 256: {
                LibraryStream.writeString(stream, value.asString());
                return;
            }
            case 16385: {
                LibraryStream.writeStringWS(stream, value.asString());
                return;
            }
        }
    }

    public static void writeStream(OutputStream stream, ByteArrayOutputStream data) throws IOException {
        byte[] bdata = data.toByteArray();
        LibraryStream.writeInt(stream, bdata.length);
        stream.write(bdata);
    }

    public static void skipByte(InputStream stream) throws IOException {
        stream.skip(1L);
    }

    public static void skipBoolean(InputStream stream) throws IOException {
        stream.skip(1L);
    }

    public static void skipCurrency(InputStream stream) throws IOException {
        LibraryStream.skipStringWS(stream);
    }

    public static void skipDateTime(InputStream stream) throws IOException {
        stream.skip(8L);
    }

    public static void skipInt(InputStream stream) throws IOException {
        stream.skip(4L);
    }

    public static void skipSingle(InputStream stream) throws IOException {
        stream.skip(4L);
    }

    public static void skipDouble(InputStream stream) throws IOException {
        stream.skip(8L);
    }

    public static void skipString(InputStream stream) throws IOException {
        int i = LibraryStream.readInt(stream);
        if (i == 0) {
            return;
        }
        stream.skip(i);
    }

    public static void skipStringWS(InputStream stream) throws IOException {
        int i = LibraryStream.readInt(stream);
        if (i == 0) {
            return;
        }
        stream.skip(i * 4);
    }

    public static void skipVariant(InputStream stream) throws IOException {
        int type = LibraryStream.readInt(stream);
        switch (type) {
            case 0: 
            case 1: {
                return;
            }
            case 3: 
            case 16: {
                LibraryStream.skipInt(stream);
                return;
            }
            case 4: {
                LibraryStream.skipSingle(stream);
                return;
            }
            case 5: {
                LibraryStream.skipDouble(stream);
                return;
            }
            case 7: {
                LibraryStream.skipDouble(stream);
                return;
            }
            case 6: {
                LibraryStream.skipCurrency(stream);
                return;
            }
            case 11: {
                LibraryStream.skipBoolean(stream);
                return;
            }
            case 17: {
                LibraryStream.skipByte(stream);
                return;
            }
            case 8: 
            case 256: {
                LibraryStream.skipString(stream);
                return;
            }
            case 16385: {
                LibraryStream.skipStringWS(stream);
                return;
            }
        }
    }

    public static void skipStreamEx(InputStream stream) throws IOException {
        int i = LibraryStream.readInt(stream);
        LibraryStream.skipStream(stream, i);
    }

    public static void skipStream(InputStream stream, int size) throws IOException {
        byte[] buffer = new byte[size];
        stream.read(buffer);
    }
}

