/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.configuration;

import io.intino.goros.egeasy.m3.configuration.CASConfiguration;
import io.intino.goros.egeasy.m3.configuration.DBConfiguration;
import io.intino.goros.egeasy.m3.configuration.DocumentRepository;
import io.intino.goros.egeasy.m3.configuration.ESBConfiguration;
import io.intino.goros.egeasy.m3.configuration.SerializerConfigurationBinary;
import io.intino.goros.egeasy.m3.configuration.SerializerConfigurationJSON;
import io.intino.goros.egeasy.m3.configuration.ServerConfiguration;
import io.intino.goros.egeasy.m3.serializer.SerializedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class EGEConfiguration {
    private static EGEConfiguration instance;
    private boolean loaded = false;
    private String centerName;
    private String modelLocation;
    private String registryLocation;
    private DocumentRepository[] documentRepositories;
    private DBConfiguration dbConfiguration = new DBConfiguration();
    private List<String> variables;
    private ServerConfiguration egSystemWebConnection = new ServerConfiguration();
    private CASConfiguration casConfiguration = new CASConfiguration();
    private ESBConfiguration esbConfiguration = new ESBConfiguration();

    private EGEConfiguration() {
        this.variables = new ArrayList<String>();
    }

    public static synchronized EGEConfiguration getInstance() {
        if (instance == null) {
            instance = new EGEConfiguration();
        }
        return instance;
    }

    public DBConfiguration getDbConfiguration() {
        return this.dbConfiguration;
    }

    public ServerConfiguration getEgSystemWebConnection() {
        return this.egSystemWebConnection;
    }

    public CASConfiguration getCasConfiguration() {
        return this.casConfiguration;
    }

    public ESBConfiguration getEsbConfiguration() {
        return this.esbConfiguration;
    }

    public String getCenterName() {
        return this.centerName;
    }

    public void setCenterName(String centerName) {
        this.centerName = centerName;
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    public void setModelLocation(String modelLocation) {
        this.modelLocation = modelLocation;
    }

    public String getRegistryLocation() {
        return this.registryLocation;
    }

    public void setRegistryLocation(String registryLocation) {
        this.registryLocation = registryLocation;
    }

    public DocumentRepository[] getDocumentRepositories() {
        return this.documentRepositories;
    }

    public void setDocumentLocation(String documentLocation) {
        String[] parts = documentLocation.split(Pattern.quote("\n"));
        this.documentRepositories = new DocumentRepository[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String repo = parts[i];
            int pos = repo.indexOf("=");
            if (pos >= 0) {
                String active = repo.substring(pos + 1);
                this.documentRepositories[i] = new DocumentRepository(repo.substring(0, pos - 1), "S".equals(active));
                continue;
            }
            this.documentRepositories[i] = new DocumentRepository(repo, true);
        }
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void loadFromFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        try {
            byte[] content = Files.readAllBytes(file.toPath());
            if (content.length > 0 && Character.toString((char)content[0]).equals("{")) {
                SerializerConfigurationJSON serializer = new SerializerConfigurationJSON();
                serializer.unserialize(this, content);
            } else {
                SerializedInputStream stream = new SerializedInputStream(content);
                SerializerConfigurationBinary serializer = new SerializerConfigurationBinary();
                serializer.unserialize(this, stream, -1);
            }
            this.loaded = true;
        }
        catch (Exception e) {
            return;
        }
    }
}

