/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.condition;

import io.intino.itrules.Trigger;
import io.intino.itrules.template.condition.BinaryOperator;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.NotExpression;
import io.intino.itrules.template.condition.Predicate;

public class BinaryExpression
implements LogicalExpression {
    private final LogicalExpression left;
    private final BinaryOperator operator;
    private final LogicalExpression right;

    public BinaryExpression(LogicalExpression left, BinaryOperator operator, LogicalExpression right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public boolean evaluate(Trigger trigger) {
        if (this.operator == BinaryOperator.AND) {
            return this.left.evaluate(trigger) && this.right.evaluate(trigger);
        }
        return this.left.evaluate(trigger) || this.right.evaluate(trigger);
    }

    public LogicalExpression left() {
        return this.left;
    }

    public BinaryOperator operator() {
        return this.operator;
    }

    public LogicalExpression right() {
        return this.right;
    }

    public String toString() {
        return this.embrace(this.left) + " " + this.operator.name() + " " + this.embrace(this.right);
    }

    private String embrace(LogicalExpression expression) {
        String result = expression.toString();
        return expression instanceof Predicate || expression instanceof NotExpression ? result : "(" + result + ")";
    }
}

