/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.formatters.spelling;

import io.intino.itrules.formatters.NumberFormatters;

public class SpanishNumberSpelling
implements NumberFormatters.NumberSpelling {
    private static final String[] numbers = new String[]{"", "uno", "dos", "tres", "cuatro", "cinco", "seis", "siete", "ocho", "nueve", "diez", "once", "doce", "trece", "catorce", "quince", "dieciseis", "diecisiete", "dieciocho", "diecinueve", "veinte"};
    private static final String[] multipleOfTenNumbers = new String[]{"", "", "", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa"};
    private static final String[] hundreds = new String[]{"", "ciento", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos"};

    @Override
    public String spell(int number) {
        return number > 0 ? this.readLessThanOneBillion(number) : "cero";
    }

    private String readLessThanOneBillion(int number) {
        return this.trim(this.readMillions(number / 1000000) + " " + this.readLessThanOneMillion(number % 1000000));
    }

    private String readMillions(int number) {
        return number > 1 ? this.readLessThanOneMillion(number) + " millones" : (number == 1 ? "un mill\u00f3n" : "");
    }

    private String readLessThanOneMillion(int number) {
        return this.trim(this.readThousands(number / 1000) + " " + this.readLessThanOneThousand(number % 1000));
    }

    private String readThousands(int number) {
        return number > 1 ? this.readLessThanOneThousand(number) + " mil" : (number == 1 ? "mil" : "");
    }

    private String readLessThanOneThousand(int number) {
        return number != 100 ? this.trim(this.readHundreds(number / 100) + " " + this.readLessThanOneHundred(number % 100)) : "cien";
    }

    private String readHundreds(int number) {
        return hundreds[number];
    }

    private String readLessThanOneHundred(int number) {
        return number <= 20 ? this.readLessThanTwenty(number) : (number < 30 ? this.readLestThanThirty(number) : this.readMultipleOfTen(number) + (String)(number % 10 == 0 ? "" : " y " + this.readLessThanTwenty(number % 10)));
    }

    private String readLestThanThirty(int number) {
        return "veinti" + this.readLessThanTwenty(number % 10);
    }

    private String readMultipleOfTen(int number) {
        return multipleOfTenNumbers[number / 10];
    }

    private String readLessThanTwenty(int number) {
        return numbers[number];
    }

    private String trim(String text) {
        return text.trim();
    }
}

