/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRendererFactory;
import io.intino.goros.modernizing.egeasy.renderers.Renderer;
import io.intino.goros.modernizing.egeasy.renderers.templates.java.EditorsTemplate;
import io.intino.goros.modernizing.egeasy.renderers.templates.konos.UITemplate;
import io.intino.goros.modernizing.egeasy.util.DefinitionUtils;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIRenderer
extends Renderer {
    private final DefinitionRendererFactory factory = new DefinitionRendererFactory();
    private final List<Definition> roomList;
    private final List<Definition> taskList;
    private static final Map<Definition, List<Definition>> Cache = new HashMap<Definition, List<Definition>>();
    private static final List<Definition> EntityTypesRendered = new ArrayList<Definition>();

    public UIRenderer(TreeNodeResource dictionary, Modernization modernization, List<Definition> roomList, List<Definition> taskList) {
        super(dictionary, modernization);
        this.roomList = roomList;
        this.taskList = taskList;
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        this.writeRouteDispatcherTemplate();
        this.writeCenterTemplate();
        this.writeEntitiesTemplate();
        this.writeFileFieldEditorTemplate();
        this.writeSignFieldEditorTemplate();
        this.writeCheckTableFieldEditorTemplate();
        this.writeContainerDocumentTemplate();
        this.writeHeaderTemplate();
        this.writeRoomOptionTemplate();
        this.writeRoomSectionTemplate();
        this.writeRoomSectionItemTemplate();
        this.writeAuthenticateTemplate();
        this.writeLoginTemplate();
        this.writeRoomTemplate();
        this.writeSessionLostTemplate();
        this.writePermissionsTemplate();
        this.writeFilterTemplates();
        this.writeExportWizard();
        this.writeValidationResult();
        this.writeFieldOptionSelectorWizard();
        this.writeFieldCodeSelectorWizard();
        this.writeFrame(this.file(), new UITemplate().render(builder.toFrame()));
        this.writeFrame(this.editorsFile(), new io.intino.goros.modernizing.egeasy.renderers.templates.konos.EditorsTemplate().render(builder.toFrame()));
        this.writeEntities();
    }

    private FrameBuilder buildFrame() {
        FrameBuilder result = this.baseFrame();
        result.add("ui");
        result.add("title", this.modernization.projectName());
        this.roomList.forEach(d -> result.add("room", this.roomFrameOf((Definition)d)));
        this.addEntities(result);
        return result;
    }

    private void writeEntities() {
        this.roomList.stream().map(this::entitySetDefinitions).flatMap(Collection::stream).distinct().forEach(d -> DefinitionUtils.entityTypesOf(d, this.modernization.includeAbstractDefinitions()).forEach(this::render));
    }

    private void addEntities(FrameBuilder result) {
        HashSet entitiesRendered = new HashSet();
        this.roomList.stream().map(this::entitySetDefinitions).flatMap(Collection::stream).distinct().forEach(d -> {
            List<Definition> entityList = DefinitionUtils.entityTypesOf(d, this.modernization.includeAbstractDefinitions());
            entityList.forEach(e -> this.addEntity(result, entitiesRendered, (Definition)e));
        });
        this.taskList.forEach(d -> this.addEntity(result, entitiesRendered, (Definition)d));
    }

    private List<Definition> entitySetDefinitions(Definition room) {
        if (!Cache.containsKey(room)) {
            Cache.put(room, DefinitionUtils.entitySetDefinitions(room, this.modernization.includeAbstractDefinitions()));
        }
        return Cache.get(room);
    }

    private void addEntity(FrameBuilder result, Set<Integer> entitiesRendered, Definition e) {
        if (entitiesRendered.contains(e.getDRC())) {
            return;
        }
        result.add("entity", this.entityFrameOf(e));
        entitiesRendered.add(e.getDRC());
    }

    private FrameBuilder entityFrameOf(Definition definition) {
        FrameBuilder result = this.baseFrame().add("entity");
        if (io.intino.goros.egeasy.m3.utils.DefinitionUtils.isTaskDefinition(definition).booleanValue()) {
            result.add("task");
        }
        result.add("name", this.nameOf(definition));
        result.add("drc", definition.getDRC());
        return result;
    }

    private FrameBuilder roomFrameOf(Definition definition) {
        FrameBuilder result = new FrameBuilder("room");
        result.add("name", this.nameOf(definition));
        io.intino.goros.egeasy.m3.utils.DefinitionUtils.newProcessDefinitions(definition, null).forEach(d -> result.add("process", this.processFrameOf((Definition)d)));
        return result;
    }

    private FrameBuilder processFrameOf(Definition definition) {
        FrameBuilder result = new FrameBuilder("process");
        result.add("name", this.nameOf(definition));
        result.add("drc", definition.getDRC());
        result.add("label", this.labelOf(definition));
        return result;
    }

    private File file() {
        return new File(this.modernization.sourceUiDirectory() + File.separator + "UI.konos");
    }

    private File editorsFile() {
        return new File(this.modernization.sourceUiDirectory() + File.separator + "Editors.konos");
    }

    private void writeCenterTemplate() {
        FrameBuilder builder = this.buildFrame().add("center");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "CenterTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeEntitiesTemplate() {
        FrameBuilder builder = this.buildFrame().add("entities");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "EntitiesTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeFileFieldEditorTemplate() {
        FrameBuilder builder = this.buildFrame().add("fileFieldEditor");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "FileFieldEditor.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeSignFieldEditorTemplate() {
        FrameBuilder builder = this.buildFrame().add("signFieldEditor");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "SignFieldEditor.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeCheckTableFieldEditorTemplate() {
        FrameBuilder builder = this.buildFrame().add("checkTableFieldEditor");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "CheckTableFieldEditor.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
        builder = this.buildFrame().add("checkTableFieldItemEditor");
        file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "CheckTableFieldItemEditor.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeContainerDocumentTemplate() {
        FrameBuilder builder = this.buildFrame().add("containerDocument");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "ContainerDocumentTemplate.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
        builder = this.buildFrame().add("documentWizard");
        file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "DocumentWizard.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeRouteDispatcherTemplate() {
        FrameBuilder builder = this.buildFrame().add("routedispatcher");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "RouteDispatcher.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeHeaderTemplate() {
        FrameBuilder builder = this.buildFrame().add("header");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "HeaderTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
        builder = this.buildFrame().add("environmentVariable");
        file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "EnvironmentVariableTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeRoomOptionTemplate() {
        FrameBuilder builder = this.buildFrame().add("roomOption");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "RoomOptionTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeRoomSectionTemplate() {
        FrameBuilder builder = this.buildFrame().add("roomSection");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "RoomSectionTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeRoomSectionItemTemplate() {
        FrameBuilder builder = this.buildFrame().add("roomSectionItem");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "RoomSectionItemTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeAuthenticateTemplate() {
        FrameBuilder builder = this.buildFrame().add("authenticate");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "AuthenticateTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeLoginTemplate() {
        FrameBuilder builder = this.buildFrame().add("login");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "LoginTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeRoomTemplate() {
        FrameBuilder builder = this.buildFrame().add("room");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "RoomTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeSessionLostTemplate() {
        FrameBuilder builder = this.buildFrame().add("sessionLost");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "SessionLostTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writePermissionsTemplate() {
        FrameBuilder builder = this.buildFrame().add("permissions");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "PermissionsTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.egeasy.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeFilterTemplates() {
        FrameBuilder builder = this.buildFrame().add("setFilterListEditor");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "SetFilterListEditor.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
        builder = this.buildFrame().add("setFilterItem");
        file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "SetFilterItem.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
        builder = this.buildFrame().add("setFilterEditor");
        file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "SetFilterEditor.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
        builder = this.buildFrame().add("setFilterSentenceEditor");
        file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "SetFilterSentenceEditor.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeExportWizard() {
        FrameBuilder builder = this.buildFrame().add("exportWizard");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "ExportWizard.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeValidationResult() {
        FrameBuilder builder = this.buildFrame().add("validationResult");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "ValidationResultTemplate.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
        builder = this.buildFrame().add("validationResultError");
        file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "FieldResultErrorTemplate.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeFieldOptionSelectorWizard() {
        FrameBuilder builder = this.buildFrame().add("fieldOptionSelectorWizard");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "FieldOptionSelectorWizard.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void writeFieldCodeSelectorWizard() {
        FrameBuilder builder = this.buildFrame().add("fieldCodeSelectorWizard");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "FieldCodeSelectorWizard.java");
        this.writeFrame(file, new EditorsTemplate().render(builder.toFrame()));
    }

    private void render(Definition definition) {
        if (EntityTypesRendered.contains(definition)) {
            return;
        }
        this.factory.renderer(this.dictionary, this.modernization, definition).write();
        EntityTypesRendered.add(definition);
    }
}

