/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.util;

import io.intino.goros.egeasy.m3.definition.base.DefType;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionContent;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionLocation;
import io.intino.goros.egeasy.m3.definition.dictionary.Dictionary;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DefinitionUtils {
    public static String basePackage(TreeNodeResource dictionary) {
        String basePackage = null;
        for (Definition d : dictionary.getDefinitions()) {
            String name = d.getName();
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            if (basePackage == null) {
                basePackage = name;
                continue;
            }
            basePackage = StringUtil.greatestCommonPrefix(basePackage, name);
        }
        return basePackage;
    }

    private static boolean isLocation(Definition definition) {
        return definition.getExtension() instanceof DefinitionExtensionLocation;
    }

    private static boolean isEntitySetDefinition(Definition definition) {
        return io.intino.goros.egeasy.m3.utils.DefinitionUtils.isCollectionDefinition(definition) != false || io.intino.goros.egeasy.m3.utils.DefinitionUtils.isCatalogDefinition(definition) != false;
    }

    private static boolean checkDefContained(Definition defContained, boolean includeAbstractDefinitions) {
        if (!(defContained instanceof DefType)) {
            return false;
        }
        if (!includeAbstractDefinitions && ((DefType)defContained).getAbstract()) {
            return false;
        }
        return io.intino.goros.egeasy.m3.utils.DefinitionUtils.isContainerDefinition(defContained);
    }

    public static boolean canCreateNew(Definition definition) {
        if (!(definition instanceof DefType)) {
            return false;
        }
        if (((DefType)definition).getAbstract()) {
            return false;
        }
        return LibraryDefinitions.getAtActive(definition);
    }

    private static void fillDefContainersContained(Definition defContained, List<Definition> listDefContainer, boolean includeAbstractDefinitions) {
        if (DefinitionUtils.checkDefContained(defContained, includeAbstractDefinitions)) {
            listDefContainer.add(defContained);
        }
        for (Definition defchildren : defContained.getChildren()) {
            DefinitionUtils.fillDefContainersContained(defchildren, listDefContainer, includeAbstractDefinitions);
        }
        List listEntitySetDefinition = defContained.getDefinitions().stream().filter(DefinitionUtils::isEntitySetDefinition).collect(Collectors.toList());
        for (Definition defEntitySet : listEntitySetDefinition) {
            List<Definition> containers = DefinitionUtils.entityTypesOf(defEntitySet, includeAbstractDefinitions);
            listDefContainer.addAll(containers);
        }
    }

    private static List<Definition> getListDefContainersContained(Definition defContained, boolean includeAbstractDefinitions) {
        ArrayList<Definition> listDefContainer = new ArrayList<Definition>();
        DefinitionUtils.fillDefContainersContained(defContained, listDefContainer, includeAbstractDefinitions);
        return listDefContainer;
    }

    public static void fillDefContent(Definition definition, List<Definition> listDefContent, boolean includeAbstractDefinitions) {
        if (definition.getExtension() instanceof DefinitionExtensionContent) {
            Definition defContained = ((DefinitionExtensionContent)definition.getExtension()).getDefinitionContained();
            List<Definition> listDefContained = DefinitionUtils.getListDefContainersContained(defContained, includeAbstractDefinitions);
            listDefContent.addAll(listDefContained);
        } else {
            for (Definition def : definition.getDefinitions()) {
                DefinitionUtils.fillDefContent(def, listDefContent, includeAbstractDefinitions);
            }
        }
    }

    private static void addDefinition(List<Definition> listDefEntitySet, Definition definition, boolean includeAbstractDefinitions) {
        if (listDefEntitySet.contains(definition)) {
            return;
        }
        listDefEntitySet.add(definition);
        if (io.intino.goros.egeasy.m3.utils.DefinitionUtils.isCollectionDefinition(definition).booleanValue()) {
            ArrayList<Definition> listDefContent = new ArrayList<Definition>();
            DefinitionUtils.fillDefContent(definition, listDefContent, includeAbstractDefinitions);
            for (Definition defContainer : listDefContent) {
                DefinitionUtils.fillEntitySetDefinition(listDefEntitySet, defContainer, includeAbstractDefinitions);
            }
        }
    }

    private static void addDefinition(List<Definition> listDefEntitySet, List<Definition> listDefinitions, boolean includeAbstractDefinitions) {
        for (Definition definition : listDefinitions) {
            DefinitionUtils.addDefinition(listDefEntitySet, definition, includeAbstractDefinitions);
        }
    }

    private static void fillEntitySetDefinition(List<Definition> listDefEntitySet, Definition definition, boolean includeAbstractDefinitions) {
        if (DefinitionUtils.isEntitySetDefinition(definition)) {
            DefinitionUtils.addDefinition(listDefEntitySet, definition, includeAbstractDefinitions);
            return;
        }
        List<Definition> listEntitySetDefinition = definition.getDefinitions().stream().filter(DefinitionUtils::isEntitySetDefinition).collect(Collectors.toList());
        DefinitionUtils.addDefinition(listDefEntitySet, listEntitySetDefinition, includeAbstractDefinitions);
        for (Definition defChildren : definition.getChildren()) {
            DefinitionUtils.fillEntitySetDefinition(listDefEntitySet, defChildren, includeAbstractDefinitions);
        }
    }

    public static List<Definition> entitySetDefinitions(Definition roomDefinition, boolean includeAbstractDefinitions) {
        if (!io.intino.goros.egeasy.m3.utils.DefinitionUtils.isRoomDefinition(roomDefinition).booleanValue()) {
            return null;
        }
        ArrayList<Definition> listDefEntitySet = new ArrayList<Definition>();
        List defLocations = roomDefinition.getDefinitions().stream().filter(DefinitionUtils::isLocation).collect(Collectors.toList());
        for (Definition defLocation : defLocations) {
            DefinitionUtils.fillEntitySetDefinition(listDefEntitySet, ((DefinitionExtensionLocation)defLocation.getExtension()).getDefinitionLocated(), includeAbstractDefinitions);
        }
        return listDefEntitySet;
    }

    private static void addContainerDefinitionsChildren(Definition defContainer, List<Definition> definitions) {
        for (Definition defChildren : defContainer.getChildren()) {
            if (!io.intino.goros.egeasy.m3.utils.DefinitionUtils.isContainerDefinition(defChildren).booleanValue()) continue;
            definitions.add(defChildren);
            DefinitionUtils.addContainerDefinitionsChildren(defChildren, definitions);
        }
    }

    private static List<Definition> getTaskTargetDefinitions(Definition defTask) {
        int[] targetDRCs = LibraryDefinitions.getAtTargetTypes(defTask);
        if (targetDRCs == null || targetDRCs.length == 0) {
            return null;
        }
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (int DRC : targetDRCs) {
            Definition defTarget = Dictionary.getInstance().findDefinition(DRC);
            if (defTarget == null) continue;
            result.add(defTarget);
            DefinitionUtils.addContainerDefinitionsChildren(defTarget, result);
        }
        return result;
    }

    public static List<Definition> getTaskDefinitions() {
        return Dictionary.getInstance().getDefinitions().stream().filter(d -> io.intino.goros.egeasy.m3.utils.DefinitionUtils.isTaskDefinition(d) != false && io.intino.goros.egeasy.m3.utils.DefinitionUtils.hasTaskFields(d)).collect(Collectors.toList());
    }

    public static List<Definition> getTaskDefinitions(List<Definition> defContainers) {
        List defTasks = Dictionary.getInstance().getDefinitions().stream().filter(d -> io.intino.goros.egeasy.m3.utils.DefinitionUtils.isTaskDefinition(d) != false && io.intino.goros.egeasy.m3.utils.DefinitionUtils.hasTaskFields(d)).collect(Collectors.toList());
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (Definition defTask : defTasks) {
            List<Definition> defTargets = DefinitionUtils.getTaskTargetDefinitions(defTask);
            if (defTargets == null) continue;
            boolean isUsed = false;
            for (Definition defTarget : defTargets) {
                isUsed = defContainers.stream().filter(d -> d.getDRC() == defTarget.getDRC()).findFirst().orElse(null) != null;
                if (!isUsed) continue;
                break;
            }
            if (!isUsed) continue;
            result.add(defTask);
        }
        return result;
    }

    public static List<Definition> entityTypesOf(Definition collectionDefinition, boolean includeAbstractDefinitions) {
        ArrayList<Definition> entityTypes = new ArrayList<Definition>();
        DefinitionUtils.fillDefContent(collectionDefinition, entityTypes, includeAbstractDefinitions);
        return entityTypes.stream().distinct().collect(Collectors.toList());
    }
}

