/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.model.EntitySetColumn;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.RendererHelper;
import io.intino.goros.modernizing.egeasy.util.DefinitionUtils;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.logging.Logger;

public abstract class Renderer {
    protected final TreeNodeResource dictionary;
    protected final Modernization modernization;
    public static final Map<Integer, String> VariantTypeMap = Map.of(1, "Integer", 2, "Real", 3, "String", 5, "Date", 7, "Date");

    public Renderer(TreeNodeResource dictionary, Modernization modernization) {
        this.dictionary = dictionary;
        this.modernization = modernization;
    }

    public abstract void write();

    protected FrameBuilder baseFrame() {
        FrameBuilder result = new FrameBuilder().add("module", this.modernization.moduleName()).add("boxName", this.modernization.boxName()).add("mock", this.modernization.isMock() ? "Mock" : "");
        String projectPackage = this.modernization.projectPackage();
        if (projectPackage != null && !projectPackage.isEmpty()) {
            result.add("package", projectPackage);
        }
        return result;
    }

    protected void writeFrame(File file, String content) {
        try {
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.getGlobal().severe(e.getMessage());
        }
    }

    protected String javaPackage() {
        return this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator;
    }

    protected String konosPackage() {
        return this.modernization.sourceUiDirectory() + File.separator + "definitions" + File.separator;
    }

    protected String nameOf(Definition definition) {
        if (definition == null) {
            return "";
        }
        return RendererHelper.nameOf(definition, this.modernization.roomCodes());
    }

    protected String shortNameOf(Definition definition) {
        if (definition == null) {
            return "";
        }
        return this.shortNameOf(RendererHelper.nameOf(definition, this.modernization.roomCodes()));
    }

    protected String shortNameOf(String name) {
        int pos = name.length() > 5 ? 5 : -1;
        return RendererHelper.shortName(name) + (pos > 0 ? name.substring(name.length() - pos) : "");
    }

    protected String variantTypeOf(EntitySetColumn column) {
        return this.variantTypeOf(column.getType());
    }

    protected String variantTypeOf(Definition definition) {
        boolean isColumn = definition.getRoot() == Metamodel.getInstance().DTColumn;
        int type = definition.getTypeValue();
        if (isColumn) {
            String value = definition.getAttributes().findAttribute("COLUMNA_BD.TIPO").stream().findFirst().orElse(null);
            type = value != null ? Integer.parseInt(value) : 256;
        }
        return this.variantTypeOf(type);
    }

    protected String variantTypeOf(int type) {
        return VariantTypeMap.getOrDefault(type, "String");
    }

    protected String normalize(String name) {
        return RendererHelper.normalize(name);
    }

    protected String basePackage() {
        return DefinitionUtils.basePackage(this.dictionary);
    }

    protected String labelOf(Definition definition) {
        String label = io.intino.goros.egeasy.m3.utils.DefinitionUtils.getDefinitionAttributeValue(definition, "ETIQUETA");
        if (label == null || label.isEmpty()) {
            label = definition.getName().contains("::") ? definition.getName().split("::")[1] : definition.getName();
        }
        return this.clean(label);
    }

    protected String placeOf(DefInstance definition) {
        return RendererHelper.placeOf(definition);
    }

    protected String clean(Object label) {
        if (label == null) {
            return null;
        }
        return ((String)label).replace("\n", "").replace("\"", "").replace("\\", "");
    }
}

