/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class UITemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.allTypes("ui", "sessionLost"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class SessionLostTemplate extends AbstractSessionLostTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n\n    public SessionLostTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        box().onProviderSessionLost(session(), e -> notifySessionLost());\n        reload.onExecute(e -> logout());\n    }\n\n    private void notifySessionLost() {\n        session().logout();\n        dialog.open();\n    }\n\n    private void logout() {\n        session().logout();\n        notifier.redirect();\n    }\n}")), this.rule().condition(this.allTypes("ui", "routedispatcher"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays;\n\nimport io.intino.alexandria.ui.Soul;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.AuthenticateTemplate;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.EntitiesTemplate;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.RoomTemplate;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.AbstractRouteDispatcher;\n\npublic class RouteDispatcher extends AbstractRouteDispatcher {\n\n    @Override\n    public void dispatchHome(Soul soul) {\n    }\n\n    @Override\n    public void dispatchLogin(Soul soul) {\n    }\n\n    @Override\n    public void dispatchRoom(Soul soul, String name) {\n        soul.display(RoomTemplate.class).open(name);\n    }\n\n    @Override\n    public void dispatchLocation(Soul soul, String room, String section, String location) {\n        soul.display(RoomTemplate.class).open(room, section, location);\n    }\n\n    @Override\n    public void dispatchLocationEntity(Soul soul, String room, String section, String location, String rrc, String drc, String view) {\n        soul.display(RoomTemplate.class).open(room, section, location, drc, rrc, view);\n    }\n\n    @Override\n    public void dispatchEntity(Soul soul, String rrc, String drc, String context) {\n        soul.currentLayer(RoomTemplate.class).openEntity(drc, rrc, context);\n    }\n\n    @Override\n    public void dispatchPermissions(Soul soul) {\n    }\n\n    @Override\n    public void dispatchToken(Soul soul, String token) {\n        soul.currentLayer(AuthenticateTemplate.class).token(token);\n    }\n}")), this.rule().condition(this.allTypes("ui", "center"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.goros.egeasy.box.ui.model.Center;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Files;\nimport java.util.Arrays;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\npublic class CenterTemplate extends AbstractCenterTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Center center;\n\n    public CenterTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public Center center() {\n        return center;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n\n        if (user() == null) {\n            session().browser().add(\"callback\", session().browser().requestUrl());\n            notifier.redirect(session().browser().baseUrl() + \"/login\");\n            return;\n        }\n\n        if (box().authService() != null && box().provider(session()).sessionInfo() == null) {\n            TGSessionInfo sessionInfo = box().provider(session()).loginCAS(io.intino.goros.egeasy.provider.Provider.webToken(), username());\n            if (sessionInfo == null || sessionInfo.getSessionID() == null || sessionInfo.getSessionID().isEmpty()) {\n                notifier.redirect(session().browser().baseUrl() + \"/permissions\");\n                return;\n            }\n        }\n\n        if (!roomsIndex().exists()) {\n            if (Model.center().roomList().size() > 0 && isLocal()) redirectToFirstRoom();\n            else redirectToMenuApp();\n            return;\n        }\n\n        refresh();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshHeader();\n        refreshRooms();\n        refreshBlocks();\n    }\n\n    private void refreshHeader() {\n        headerStamp.room(null);\n        headerStamp.refresh();\n    }\n\n    private void refreshBlocks() {\n        loadingBlock.hide();\n        mainBlock.show();\n    }\n\n    private void refreshRooms() {\n        File indexFile = roomsIndex();\n        if (indexFile.exists()) refreshRoomsFromIndex(indexFile);\n        else refreshRoomsFromCenter();\n    }\n\n    private void refreshRoomsFromCenter() {\n        Center center = Model.center();\n        List<String> visibleRoomList = Arrays.stream(box().provider(session()).loadRooms()).map(TGIdentifier::getName).collect(Collectors.toList());\n        center.roomList().stream().filter(r -> isVisible(r.label(), visibleRoomList)).forEach(room -> fill(room, rooms.add()));\n    }\n\n    private void refreshRoomsFromIndex(File indexFile) {\n        try {\n            if (!indexFile.exists()) return;\n            List<String> visibleRoomList = Arrays.stream(box().provider(session()).loadRooms()).map(TGIdentifier::getName).collect(Collectors.toList());\n            Files.readAllLines(indexFile.toPath()).stream().filter(r -> isVisible(r.split(\"\t\")[0], visibleRoomList)).forEach(l -> fill(l, rooms.add()));\n        } catch (IOException e) {\n            Logger.error(e);\n        }\n    }\n\n    private boolean isVisible(String room, List<String> visibleRoomList) {\n        return visibleRoomList.contains(room);\n    }\n\n    private void fill(Room room, RoomOptionTemplate view) {\n        view.room(room.label(), room.name(), RoomOptionTemplate.Mode.InternalLink);\n        view.refresh();\n    }\n\n    private void fill(String line, RoomOptionTemplate view) {\n        view.room(line.split(\"\\t\")[0], line.split(\"\\t\")[1], RoomOptionTemplate.Mode.ExternalLink);\n        view.refresh();\n    }\n\n    private File roomsIndex() {\n        return new File(box().configuration().home() + \"/rooms-directory.tsv\");\n    }\n\n    private boolean isLocal() {\n        return box().configuration().url().contains(\"http://localhost\");\n    }\n\n    private void redirectToFirstRoom() {\n        notifier.redirect(session().browser().baseUrl() + \"/rm/\" + Model.center().roomList().get(0).name());\n    }\n\n    private void redirectToMenuApp() {\n        String url = box().configuration().url();\n        url = url != null && url.endsWith(\"/\") ? url.substring(0, url.length()-1) : url;\n        url = url != null && url.lastIndexOf(\"/\") != -1 ? url.substring(0, url.lastIndexOf(\"/\")) : null;\n        notifier.redirect(url != null && !url.equals(\"http:/\") && !url.equals(\"https:/\") ? url : session().browser().baseUrl());\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "header"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\n\nimport java.util.LinkedHashMap;\nimport java.util.List;\nimport java.util.Map;\n\npublic class HeaderTemplate extends AbstractHeaderTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Map<String, String> variables = new LinkedHashMap<>();\n\n    public HeaderTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public HeaderTemplate room(Room room) {\n        this.room = room;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        if (box().authService() != null) user.logoutUrl(box().authService().logoutUrl());\n        user.onBeforeLogout(event -> {\n            if (box().authService() != null) box().authService().logout(null);\n            box().provider(session()).logout();\n        });\n        rooms.onExecute(e -> notifier.redirect(centerUrl()));\n        addEnvironmentVariable.onExecute(e -> addEnvironmentVariable());\n        environmentVariablesDialog.onOpen(e -> refreshEnvironmentVariablesDialog());\n        saveEnvironmentVariables.onExecute(e -> saveEnvironmentVariables());\n        datosPersonalesDialog.onOpen(e -> refreshDatosPersonalesDialog());\n        datosProfesionalesDialog.onOpen(e -> refreshDatosProfesionalesDialog());\n        rolesDialog.onOpen(e -> refreshRolesDialog());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        rooms.visible(room != null);\n        roomsSeparator.visible(room != null);\n        subtitle.value(room != null ? room.label() : \"Inicio\");\n    }\n\n    private void addEnvironmentVariable() {\n        long count = variables.keySet().stream().filter(v -> v.startsWith(\"Variable \")).count();\n        variables.put(\"Variable \" + (count+1), \"\");\n        refreshEnvironmentVariables();\n    }\n\n    private void refreshEnvironmentVariablesDialog() {\n        variables = new LinkedHashMap<>(box().provider(session()).loadUserVariables());\n        loadingEnvironmentVariables.visible(true);\n        environmentVariablesBlock.visible(false);\n        refreshEnvironmentVariables();\n        loadingEnvironmentVariables.visible(false);\n        environmentVariablesBlock.visible(true);\n    }\n\n    private void refreshEnvironmentVariables() {\n        environmentVariables.clear();\n        variables.forEach((key, value) -> fill(key, value, environmentVariables.add()));\n    }\n\n    private void fill(String variable, String value, EnvironmentVariableTemplate display) {\n        display.variable(variable, value);\n        display.onChange((key, v) -> {\n            if (!variable.equals(key)) variables.remove(variable);\n            variables.put(key, v);\n        });\n        display.onRemove(key -> {\n            variables.remove(key);\n            refreshEnvironmentVariables();\n        });\n        display.refresh();\n    }\n\n    private void saveEnvironmentVariables() {\n        environmentVariablesDialog.close();\n        boolean saved = box().provider(session()).saveUserVariables(variables);\n        if (saved) notifyUser(\"Se han actualizado las variables de entorno\", UserMessage.Type.Success);\n        else notifyUser(\"No se han podido actualizar las variables de entorno\", UserMessage.Type.Error);\n    }\n\n    private String centerUrl() {\n        String url = box().configuration().url();\n        url = url != null && url.endsWith(\"/\") ? url.substring(0, url.length()-1) : url;\n        url = url != null && url.lastIndexOf(\"/\") != -1 ? url.substring(0, url.lastIndexOf(\"/\")) : null;\n        return url != null && !url.equals(\"http:/\") && !url.equals(\"https:/\") ? url : session().browser().baseUrl();\n    }\n\n    private void refreshDatosPersonalesDialog() {\n        username.value(\"-\");\n        fullname.value(\"-\");\n        surname.value(\"-\");\n        lastname.value(\"-\");\n        nif.value(\"-\");\n    }\n\n    private void refreshDatosProfesionalesDialog() {\n        sede.value(\"-\");\n        departamento.value(\"-\");\n        cargo.value(\"-\");\n        telefonos.clear();\n        correoElectronico.value(\"-\");\n    }\n\n    private void refreshRolesDialog() {\n    }\n}")), this.rule().condition(this.allTypes("ui", "environmentVariable"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.BiConsumer;\nimport java.util.function.Consumer;\n\npublic class EnvironmentVariableTemplate extends AbstractEnvironmentVariableTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String _name;\n    private String _value;\n    private BiConsumer<String, String> changeListener;\n    private Consumer<String> removeListener;\n\n    public EnvironmentVariableTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void variable(String name, String value) {\n        this._name = name;\n        this._value = value;\n    }\n\n    public void onChange(BiConsumer<String, String> listener) {\n        this.changeListener = listener;\n    }\n\n    public void onRemove(Consumer<String> listener) {\n        this.removeListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        name.onChange(e -> changeListener.accept(e.value(), value.value()));\n        value.onChange(e -> changeListener.accept(name.value(), e.value()));\n        remove.onExecute(e -> removeListener.accept(name.value()));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        name.value(_name);\n        value.value(_value);\n    }\n}")), this.rule().condition(this.allTypes("ui", "roomOption"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class RoomOptionTemplate extends AbstractRoomOptionTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String label;\n    private String link;\n    private Mode mode;\n\n    public RoomOptionTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public enum Mode { ExternalLink, InternalLink }\n    public RoomOptionTemplate room(String label, String link, Mode mode) {\n        this.label = label;\n        this.link = link;\n        this.mode = mode;\n        return this;\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshSite();\n        refreshPage();\n    }\n\n    private void refreshSite() {\n        site.visible(mode == Mode.ExternalLink);\n        if (mode != Mode.ExternalLink) return;\n        site.title(label);\n        site.site(link);\n    }\n\n    private void refreshPage() {\n        page.visible(mode == Mode.InternalLink);\n        if (mode != Mode.InternalLink) return;\n        page.title(label);\n        page.path(\"/rm/\" + link);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "roomSection"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.net.URL;\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class RoomSectionTemplate extends AbstractRoomSectionTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Section section;\n    private Consumer<String> selectLocationListener;\n\n    public RoomSectionTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public RoomSectionTemplate room(Room room) {\n        this.room = room;\n        return this;\n    }\n\n    public RoomSectionTemplate section(Section section) {\n        this.section = section;\n        return this;\n    }\n\n    public RoomSectionTemplate onSelectLocation(Consumer<String> listener) {\n        this.selectLocationListener = listener;\n        return this;\n    }\n\n    public void showItems() {\n        itemsBlock.visible(true);\n    }\n\n    public void hideItems() {\n        itemsBlock.visible(false);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        label.value(section.label());\n        icon.value(iconUrl());\n        refreshLocations();\n    }\n\n    private void refreshLocations() {\n        List<Location> locations = section.locations();\n        refreshFirstLocation(locations);\n        section.locations().forEach(location -> fill(location, items.add()));\n    }\n\n    private void refreshFirstLocation(List<Location> locations) {\n        Location firstLocation = !locations.isEmpty() ? locations.get(0) : null;\n        if (firstLocation == null) return;\n        labelLink.address(path -> path.replace(\":name\", StringUtil.encode(room.name())).replace(\":section\", StringUtil.encode(section.label())).replace(\":location\", StringUtil.encode(firstLocation.name())));\n    }\n\n    private URL iconUrl() {\n        return section.icon();\n    }\n\n    private void fill(Location location, RoomSectionItemTemplate view) {\n        view.room(room);\n        view.section(section);\n        view.location(location);\n        view.onSelect(e -> selectLocationListener.accept(location.label()));\n        view.refresh();\n    }\n}")), this.rule().condition(this.allTypes("ui", "roomSectionItem"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class RoomSectionItemTemplate extends AbstractRoomSectionItemTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Section section;\n    private Location location;\n    private Consumer<Location> selectListener;\n\n    public RoomSectionItemTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public RoomSectionItemTemplate room(Room room) {\n        this.room = room;\n        return this;\n    }\n\n    public RoomSectionItemTemplate section(Section section) {\n        this.section = section;\n        return this;\n    }\n\n    public RoomSectionItemTemplate location(Location location) {\n        this.location = location;\n        return this;\n    }\n\n    public RoomSectionItemTemplate onSelect(Consumer<Location> listener) {\n        selectListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        label.onExecute(e -> selectListener.accept(location));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        label.address(path -> path.replace(\":name\", StringUtil.encode(room.name())).replace(\":section\", StringUtil.encode(section.label().toLowerCase())).replace(\":location\", StringUtil.encode(location.name().toLowerCase())));\n        label.title(location.label());\n    }\n}")), this.rule().condition(this.allTypes("ui", "authenticate"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.commands.ege.EgeCommands;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class AuthenticateTemplate extends AbstractAuthenticateTemplate<")).output(this.mark("boxName", "firstUperCase")).output(this.literal("Box> {\n    private String token;\n\n    public AuthenticateTemplate(")).output(this.mark("boxName", "firstUperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void token(String token) {\n        this.token = token;\n        refresh();\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        logoutButton.onExecute(e -> {\n            session().logout();\n            box().provider(session()).logout();\n            if (box().authService() != null) box().authService().logout(null);\n            String redirectUrl = box().authService() != null ? box().authService().logoutUrl() : session().browser().requestUrl();\n            notifier.redirect(redirectUrl);\n        });\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n\n        username.value(username() != null ? \"Sesi\u00f3n iniciada en el Gobierno de Canarias como \" + username() : null);\n        logoutButton.visible(user() != null);\n\n        if (!box().commands(EgeCommands.class).isValid(box().provider(session()), token)) {\n            loadingLayer.visible(false);\n            successBlock.visible(false);\n            failureBlock.visible(true);\n            failureMessage.value(\"Token inv\u00e1lido\");\n            closeBlock.visible(true);\n            return;\n        }\n\n        if (user() == null) {\n            session().browser().add(\"callback\", session().browser().requestUrl());\n            notifier.redirect(session().browser().baseUrl() + \"/login\");\n            return;\n        }\n\n        successBlock.visible(false);\n        failureBlock.visible(false);\n        closeBlock.visible(false);\n\n        TGSessionInfo session = box().commands(EgeCommands.class).notifyLogin(box().provider(session()), user(), token);\n        boolean logged = session != null && session.getSessionID() != null && !session.getSessionID().isEmpty();\n        loadingLayer.visible(false);\n        successBlock.visible(logged);\n        if (logged) successMessage.value(\"Sesi\u00f3n iniciada correctamente con el usuario \" + username());\n        failureBlock.visible(!logged);\n        if (!logged) failureMessage.value(session != null ? session.getErrorMessage() : \"Se ha producido un error al iniciar la sesi\u00f3n en ")).output(this.mark("title", new String[0])).output(this.literal("\");\n        closeBlock.visible(true);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "login"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.services.push.User;\nimport org.apache.commons.io.IOUtils;\n\nimport io.intino.goros.egeasy.box.ui.model.Center;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\n\nimport java.io.IOException;\nimport java.nio.charset.StandardCharsets;\nimport java.util.Timer;\nimport java.util.TimerTask;\n\npublic class LoginTemplate extends AbstractLoginTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String selectedUsername;\n    private String selectedPassword;\n    private Timer loginTimer = null;\n\n    private static final String Styles = \"<style>table { border-spacing: 0; margin-bottom: 20px; width: 80%; } th, td { padding: 5px; text-align: center } th { background: #145b9f; color: white } .e { background: #f1f1f1; } .r { text-align: right; }</style>\";\n\n    public LoginTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        Center center = Model.center();\n        title.value(center.label());\n        loginButton.onExecute(e -> login());\n        initIntro(center);\n        initUsernameField();\n        initPasswordField();\n    }\n\n    private void initIntro(Center center) {\n        introPage.content(introContent(center));\n        introPage.refresh();\n    }\n\n    private String introContent(Center center) {\n        try {\n            String content = Styles + IOUtils.toString(LoginTemplate.class.getResourceAsStream(\"/home.html\"), StandardCharsets.UTF_8);\n            return content.replace(\"{label}\", center.label());\n        } catch (IOException e) {\n            Logger.error(e);\n            return \"\";\n        }\n    }\n\n    private void login() {\n        if (loginTimer != null) loginTimer.cancel();\n        loginTimer = new Timer();\n        loginTimer.schedule(new TimerTask() {\n            @Override\n            public void run() {\n                error.value(\"\");\n\n                if (selectedUsername == null) {\n                    error.value(\"Indique un nombre de usuario v\u00e1lido\");\n                    return;\n                }\n\n                if (selectedPassword == null) {\n                    error.value(\"Indique una contrase\u00f1a v\u00e1lida\");\n                    return;\n                }\n\n                try {\n                    loginButton.title(\"Iniciando sesi\u00f3n...\");\n                    loginButton.readonly(true);\n                    TGSessionInfo session = box().provider(session()).loginLDAP(selectedUsername, selectedPassword);\n                    if (session == null) {\n                        error.value(\"Error al iniciar sesi\u00f3n. Compruebe su nombre de usuario y/o contrase\u00f1a.\");\n                        loginButton.title(\"Iniciar sesi\u00f3n\");\n                        loginButton.readonly(false);\n                        return;\n                    }\n                    session().user(new User().username(selectedUsername).fullName(session.getFullName()));\n                    redirect();\n                } catch (Exception e) {\n                    error.value(\"Error al iniciar sesi\u00f3n. Contacte con el administrador\");\n                    loginButton.title(\"Iniciar sesi\u00f3n\");\n                    loginButton.readonly(false);\n                }\n\n            }\n        }, 100);\n    }\n\n    private void initUsernameField() {\n        username.onChange(event -> selectedUsername = event.value());\n        username.onEnterPress(event -> {\n            selectedUsername = event.value();\n            login();\n        });\n    }\n\n    private void initPasswordField() {\n        password.onChange(event -> selectedPassword = event.value());\n        password.onEnterPress(event -> {\n            selectedPassword = event.value();\n            login();\n        });\n    }\n\n    private void redirect() {\n        String callback = session().browser().preference(\"callback\");\n        notifier.redirect(callback != null ? callback : session().browser().baseUrl());\n        session().browser().add(\"callback\", null);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "entities"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.EntitySetItemContainer;\nimport io.intino.goros.egeasy.box.ui.datasources.EntitySetDatasource;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.Set;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class EntitiesTemplate extends AbstractEntitiesTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> implements EntitySetItemContainer {\n    private TGRoom room;\n    private String roomName;\n    private String section;\n    private String location;\n    private TGResource entity;\n    private String backTitle;\n    private Function<String, String> backAddressResolver;\n    private Consumer<EntitySetItem> backListener;\n    private Consumer<EntitySetItem> removeListener;\n    private boolean readonly = true;\n    private String view = null;\n\n    public static final Set<Integer> Entities = Set.of(")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "drcDeclaration").multiple(","))).output(this.literal(");\n\n    public EntitiesTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void backInfo(String title, Function<String, String> addressResolver, Consumer<EntitySetItem> listener) {\n        this.backTitle = title;\n        this.backAddressResolver = addressResolver;\n        this.backListener = listener;\n    }\n\n    @Override\n    public void onRemove(Consumer<EntitySetItem> listener) {\n        this.removeListener = listener;\n    }\n\n    @Override\n    public void onDirty(Consumer<Boolean> listener) {\n    }\n\n    @Override\n    public void room(TGRoom room, String roomName) {\n        this.room = room;\n        this.roomName = roomName;\n    }\n\n    @Override\n    public void section(String section) {\n        this.section = section;\n    }\n\n    @Override\n    public void location(String location) {\n        this.location = location;\n    }\n\n    @Override\n    public EntitySetItem entity() {\n        return entity != null ? EntitySetDatasource.itemOf(entity) : null;\n    }\n\n    @Override\n    public void entity(EntitySetItem entity) {\n        if (this.entity != null && this.entity.getERC() == entity.rrc() && this.entity.getDRC() == entity.drc()) return;\n        this.entity = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    }\n\n    public void entity(TGResource entity) {\n        this.entity = entity;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void selectView(String view) {\n        this.view = view;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "selectView").multiple("\n"))).output(this.literal("\n    }\n\n    public void view(String view) {\n        this.view = view;\n    }\n\n    public void open(TGResource entity) {\n        this.entity = entity;\n        refresh();\n    }\n\n    public boolean dirty() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return false;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "dirty").multiple("\n"))).output(this.literal("\n        return false;\n    }\n\n    public void endEdition() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "endEdition").multiple("\n"))).output(this.literal("\n    }\n\n    public void openSaveDialog(Consumer<Boolean> listener) {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "openSaveDialog").multiple("\n"))).output(this.literal("\n    }\n\n    public io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult silentSave() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return null;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "silentSave").multiple("\n"))).output(this.literal("\n        return ValidateResult.empty();\n    }\n\n    public io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult save() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return null;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "save").multiple("\n"))).output(this.literal("\n        return ValidateResult.empty();\n    }\n\n    public void forceSave() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "forceSave").multiple("\n"))).output(this.literal("\n    }\n\n    public void showValidationErrors(ValidateResult errors) {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "validateErrors").multiple("\n"))).output(this.literal("\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "init").multiple("\n"))).output(this.literal("\n        task.onShow(e -> {\n            task.taskStamp.clear();\n            TaskTemplate template = task.taskStamp.add();\n            template.task((TGTask) entity);\n            template.refresh();\n        });\n    }\n\n    @Override\n    public void refresh() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        notFound.hide();\n        task.hide();\n        if (drc == -1) {\n            notFound.show();\n            return;\n        }\n        refreshEntity(drc);\n    }\n\n    private void hideEntities() {\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "hide").multiple("\n"))).output(this.literal("\n    }\n\n    private void refreshEntity(int drc) {\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "refresh").multiple("\n"))).output(this.literal("\n        hideEntities();\n        if (!task.isVisible()) task.show();\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "room"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.Display;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\n\nimport io.intino.alexandria.ui.services.push.User;\nimport io.intino.goros.egeasy.box.ui.EntitySetItemContainer;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.box.ui.RoomSectionContainer;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.TaskTemplate;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.HashMap;\nimport java.util.function.Consumer;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.stream.Collectors;\n\npublic class RoomTemplate extends AbstractRoomTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Section selectedSection;\n    private Location location;\n    private TGResource entity;\n    private TGResource addedProcess;\n    private List<TaskSetItem> availableTaskSet;\n    private TaskSetItem selectedTask;\n    private BlockConditional current = null;\n    private boolean readonly = true;\n    private Object context;\n    private Consumer<EntitySetItem> removeListener;\n    private Consumer<Boolean> finishProcessListener;\n    private User finishEditionSender;\n    private EntitySetItem finishEditionEntity;\n    private Consumer<Boolean> finishEditionCallback;\n\n    public RoomTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n\n        if (user() == null) {\n            session().browser().add(\"callback\", session().browser().requestUrl());\n            notifier.redirect(session().browser().baseUrl() + \"/login\");\n            return;\n        }\n\n        if (box().authService() != null && box().provider(session()).sessionInfo() == null) {\n            TGSessionInfo sessionInfo = box().provider(session()).loginCAS(io.intino.goros.egeasy.provider.Provider.webToken(), username());\n            if (sessionInfo == null || sessionInfo.getSessionID() == null || sessionInfo.getSessionID().isEmpty()) {\n                notifier.redirect(session().browser().baseUrl() + \"/permissions\");\n                return;\n            }\n        }\n\n        initDrawer();\n        entityLayerTrigger.onOpen(e -> fillLayer(e.layer()));\n        selectTask.onExecute(e -> startTask());\n        taskSelector.onSelect(e -> selectTask.readonly(e.selection().isEmpty()));\n        taskSelectorDialog.onOpen(e -> refreshTaskSelectorDialog());\n        contextBlock.onShow(e -> refreshTaskContext());\n        taskStarterStamp.onStarted(e -> refreshTaskStarted());\n        finishEditionDialog.onOpen(e -> refreshFinishEditionDialog());\n        acceptFinishEdition.onExecute(e -> acceptFinishEdition());\n        rejectFinishEdition.onExecute(e -> rejectFinishEdition());\n    }\n\n    public void open(String name) {\n        room = Model.room(name);\n        if (user() == null) return;\n//            if (room == null || io.intino.goros.egeasy.box.ProviderHelper.room(room.drc(), box().provider(session())) == null) {\n//                notifier.redirect(session().browser().baseUrl() + \"/permissions\");\n//                return;\n//            }\n        refresh();\n    }\n\n    public void open(String room, String section, String location) {\n        open(room, section, location, true);\n    }\n\n    public boolean isEmbedded() {\n        return soul().currentLayer() != null;\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    public void open(String room, String section, String location, String drc, String rrc, String view) {\n        if (this.location == null || !location.equals(this.location.name())) open(room, section, location, false);\n        if (current == null) return;\n        current.children().stream().filter(c -> c instanceof RoomSectionContainer).forEach(c -> ((RoomSectionContainer)c).open(selectedSection, this.location, Integer.parseInt(drc), Integer.parseInt(rrc), view));\n    }\n\n    public void openEntity(String drc, String rrc, String context) {\n        this.room = null;\n        this.selectedSection = null;\n        this.location = null;\n        this.entity = box().provider(session()).openResource(java.lang.Integer.parseInt(rrc), java.lang.Integer.parseInt(drc));\n        this.context = load(context);\n        this.removeListener = removeListener != null ? removeListener : e -> notifier.redirect();\n        refresh();\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void onRemove(Consumer<EntitySetItem> listener) {\n        this.removeListener = listener;\n    }\n\n    public boolean checkDirty(Consumer<Boolean> saveListener) {\n        if (!entities.dirty()) {\n            if (entity != null) box().provider(session()).endEditionResource(entity.getERC());\n            return true;\n        }\n        entities.openSaveDialog(saveListener);\n        return false;\n    }\n\n    private static final Map<String, Map<Integer, String>> processMap = new HashMap<>() {{\n        ")).output(this.mark("room", "processes").multiple("\n")).output(this.literal("\n    }};\n    private void initDrawer() {\n        drawer.open();\n        drawer.onToggle(this::toggleSections);\n        addProcess.onExecute(e -> addProcess(e.option()));\n    }\n\n    public void addProcess(String label, Integer drc, Integer sourceErc, Consumer<Boolean> listener) {\n        finishProcessListener = listener;\n        if (drc == null || drc == -1) {\n            notifyUser(\"No se ha podido crear el proceso\", UserMessage.Type.Error);\n            return;\n        }\n        notifyUser(String.format(\"Creando proceso '%s'\", label.toLowerCase()), UserMessage.Type.Loading);\n        addedProcess = box().provider(session()).createProcess(drc, sourceErc != null ? sourceErc : io.intino.goros.egeasy.m3.constant.Constants.kNullERC);\n        if (addedProcess == null) {\n            notifyUser(\"No se ha podido crear el proceso\", UserMessage.Type.Error);\n            return;\n        }\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(addedProcess.getERC());\n        availableTaskSet = set != null ? TaskSetDatasource.itemsOf(set) : Collections.emptyList();\n        notifyUser(\"Proceso creado\", UserMessage.Type.Success);\n        if (availableTaskSet.isEmpty()) {\n            TGTask addedTask = (TGTask) addedProcess;\n            entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(addedTask.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(((TGTask) addedProcess).getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(addedTask));\n            entityLayerTrigger.openLayer();\n            return;\n        }\n        if (availableTaskSet.size() == 1) {\n            startTask(availableTaskSet.get(0));\n            return;\n        }\n        taskSelectorDialog.open();\n    }\n\n    private void addProcess(String option) {\n        addProcess(option, DisplayHelper.processDRCOf(processMap.get(room.name()), option), null, null);\n    }\n\n    private void startTask() {\n        List<String> selection = taskSelector.selection();\n        if (selection.isEmpty()) {\n            notifyUser(\"Debe seleccionar una tarea\", UserMessage.Type.Warning);\n            return;\n        }\n        String selected = selection.get(0);\n        startTask(availableTaskSet.stream().filter(t -> t.name().equals(selected)).findFirst().orElse(null));\n    }\n\n    private void startTask(TaskSetItem task) {\n        if (task == null) {\n            notifyUser(\"No se ha podido abrir la tarea\", UserMessage.Type.Error);\n            return;\n        }\n        selectedTask = task;\n        taskStarterStamp.task((TGTask) box().provider(session()).openResource(selectedTask.rrc(), selectedTask.drc()));\n        taskStarterStamp.start();\n    }\n\n    private void refreshTaskStarted() {\n        TGTask task = (TGTask) box().provider(session()).openResource(selectedTask.rrc(), selectedTask.drc());\n        entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(selectedTask));\n        entityLayerTrigger.openLayer();\n    }\n\n    private void refreshTaskSelectorDialog() {\n        taskSelector.clear();\n        taskSelector.addAll(availableTaskSet.stream().map(TaskSetItem::name).collect(Collectors.toList()));\n    }\n\n    private void fillLayer(Layer<?, ?> layer) {\n        EntitySetItem entity = selectedTask.relatedObject();\n        RoomTemplate template = new RoomTemplate(box());\n        template.readonly(false);\n        layer.title(entity.name());\n        layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n        layer.onClose(e -> {\n            if (finishProcessListener != null) finishProcessListener.accept(true);\n        });\n        layer.template(template);\n    }\n\n    private void toggleSections(ToggleEvent event) {\n        if (event.state() == ToggleEvent.State.On) showSections();\n        else hideSections();\n    }\n\n    private void showSections() {\n        addProcess.visible(true);\n        developedBy.visible(true);\n        headerBlock.show();\n        sections.children().forEach(child -> ((RoomSectionTemplate) child).showItems());\n        refreshHabitaciones();\n    }\n\n    private void hideSections() {\n        addProcess.visible(false);\n        developedBy.visible(false);\n        headerBlock.hide();\n        sections.children().forEach(child -> ((RoomSectionTemplate)child).hideItems());\n        refreshHabitaciones();\n    }\n\n    private void refreshHabitaciones() {\n        ")).output(this.mark("room", "refresh").multiple("\n")).output(this.literal("\n    }\n\n    private Object load(String context) {\n        if (StringUtil.isTask(context)) return box().provider(session()).openResource(StringUtil.erc(context), StringUtil.drc(context));\n        return null;\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshDrawer();\n        refreshLayers();\n        refreshRoom();\n        io.intino.alexandria.ui.utils.DelayerUtil.execute(this, d -> refreshContext(), 0);\n        refreshEntity();\n    }\n\n    private void refreshDrawer() {\n        List<String> options = room != null ? new ArrayList<>(processMap.getOrDefault(room.name(), new HashMap<>()).values()) : Collections.emptyList();\n        addProcess.options(options);\n        addProcess.visible(!options.isEmpty());\n        toolbar.visible(!options.isEmpty());\n    }\n\n    private void refreshRoom() {\n        if (room == null) return;\n        refreshHeader();\n        if (sections.children().isEmpty()) room.sectionList().forEach(s -> fill(s, sections.add()));\n        if (selectedSection != null) open(selectedSection, location);\n        else openFirstSection();\n    }\n\n    private void refreshContext() {\n        contextBlock.visible(context != null);\n    }\n\n    private void refreshTaskContext() {\n        if (!(context instanceof TGTask)) return;\n        taskStamp.clear();\n        TaskTemplate template = taskStamp.add();\n        template.task((TGTask) context);\n        template.onBeforeFinish(c -> entities.silentSave());\n        template.onBeforeContinueWithWarnings(c -> entities.forceSave());\n        template.onValidationErrors(errors -> entities.showValidationErrors(errors));\n        template.mode(TaskTemplate.Mode.Summary);\n        template.refresh();\n    }\n\n    private void refreshEntity() {\n        boolean readonly = this.readonly && (entity == null || !box().provider(session()).isEditingResource(entity.getERC()));\n        entities.onRemove(removeListener);\n        entities.readonly(readonly && context == null);\n        entities.open(entity);\n    }\n\n    private void refreshHeader() {\n        headerStamp.room(room);\n        headerStamp.refresh();\n    }\n\n    private void refreshLayers() {\n        boolean existsRoom = room != null && habitacion() != null;\n        notFoundBlock.visible(!existsRoom && entity == null);\n        mainBlock.visible(existsRoom);\n        loadingBlock.visible(false);\n        entitiesBlock.visible(entity != null);\n    }\n\n    private void fill(Section section, RoomSectionTemplate view) {\n        view.room(room);\n        view.section(section);\n        //view.onSelectLocation(location -> open(section, location));\n        view.refresh();\n    }\n\n    private void openFirstSection() {\n        if (room.sectionList().size() <= 0) return;\n        Section section = room.sectionList().get(0);\n        Location location = section.locations().get(0);\n        open(section, location);\n    }\n\n    private boolean checkRoomSectionDirty(String room, String section, String location) {\n        if (current == null) return true;\n        return current.children().stream().filter(c -> c instanceof RoomSectionContainer).anyMatch(c -> ((RoomSectionContainer) c).checkDirty(e -> open(room, section, location, true)));\n    }\n\n    private void open(String room, String section, String location, boolean checkDirty) {\n        if (checkDirty && !checkRoomSectionDirty(room, section, location)) return;\n        if (this.room != null && this.room.name().equals(StringUtil.decode(room)) && equalsSection(StringUtil.decode(section)) && this.location != null && this.location.name().equals(StringUtil.decode(location))) {\n            if (current != null) current.children().stream().filter(c -> c instanceof RoomSectionContainer).forEach(c -> ((RoomSectionContainer)c).back());\n            return;\n        }\n        this.room = Model.room(StringUtil.decode(room));\n        this.selectedSection = sectionOf(StringUtil.decode(section));\n        this.location = this.selectedSection.location(StringUtil.decode(location));\n        this.entity = null;\n        if (user() == null) return;\n        refresh();\n    }\n\n    private void open(Section section, String location) {\n        open(section, section.location(location));\n    }\n\n    private void open(Section section, Location location) {\n        if (current != null) current.hide();\n        current = (BlockConditional<?,?>) habitacion();\n        notFoundBlock.visible(current == null);\n        if (current != null) {\n            current.show();\n            current.children().stream().filter(c -> c instanceof RoomSectionContainer).forEach(c -> ((RoomSectionContainer)c).open(section, location));\n        }\n    }\n\n    private Display habitacion() {\n        return habitaciones.children().stream().filter(h -> h.name().toLowerCase().equals(room.name())).findFirst().orElse(null);\n    }\n\n    private Section sectionOf(String section) {\n        return room.sectionList().stream().filter(s -> s.label().equalsIgnoreCase(section) || DisplayHelper.normalize(s.label()).toLowerCase().equalsIgnoreCase(section)).findFirst().orElse(null);\n    }\n\n    private boolean equalsSection(String key) {\n        return selectedSection != null && (selectedSection.label().equalsIgnoreCase(key) || DisplayHelper.normalize(selectedSection.label()).toLowerCase().equalsIgnoreCase(key));\n    }\n\n    public void requestEdition(EntitySetItem entity, User sender, Consumer<Boolean> callback) {\n        this.finishEditionSender = sender;\n        this.finishEditionEntity = entity;\n        this.finishEditionCallback = callback;\n        finishEditionDialog.open();\n    }\n\n    private void refreshFinishEditionDialog() {\n        finishEditionMessage.value(String.format(\"%s solicita la edici\u00f3n de %s. \u00bfDesea liberar el elemento?\", finishEditionSender.fullName(), finishEditionEntity.name()));\n    }\n\n    private void acceptFinishEdition() {\n        finishEditionDialog.close();\n        if (finishEditionCallback == null) return;\n        box().provider(session()).endEditionResource(finishEditionEntity.rrc());\n        endEditionMode();\n        releaseRelatedTasks();\n        finishEditionCallback.accept(true);\n    }\n\n    private void endEditionMode() {\n        List<Display> displays = soul().getAll().stream().filter(d -> d instanceof EntitySetItemContainer && ((EntitySetItemContainer)d).entity() != null && ((EntitySetItemContainer)d).entity().rrc() == finishEditionEntity.rrc()).distinct().collect(Collectors.toList());\n        displays.forEach(this::endEditionMode);\n    }\n\n    private void endEditionMode(Display<?, ?> display) {\n        ((EntitySetItemContainer) display).readonly(true);\n        display.refresh();\n    }\n\n    private void releaseRelatedTasks() {\n        List<RoomTemplate> displays = soul().displays(RoomTemplate.class).stream().distinct().collect(Collectors.toList());\n        displays.forEach(this::releaseRelatedTasks);\n    }\n\n    private void releaseRelatedTasks(RoomTemplate room) {\n        if (!(room.context instanceof TGTask)) return;\n        TGTask task = (TGTask) room.context;\n        if (task.getTargetIdentifier() == null || task.getTargetIdentifier().getERC() != finishEditionEntity.rrc())\n            return;\n        box().provider(session()).stopWorkingTask(task.getERC(), task.getDRC());\n        room.context = box().provider(session()).openResource(task.getERC(), task.getDRC());\n        room.refreshTaskContext();\n    }\n\n    private void rejectFinishEdition() {\n        finishEditionDialog.close();\n        if (finishEditionCallback == null) return;\n        finishEditionCallback.accept(false);\n    }\n\n}")), this.rule().condition(this.allTypes("entity", "task"), this.trigger("init")).output(this.mark("name", "firstLowerCase")).output(this.literal(".onShow(e -> {\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.entity(entity);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.readonly(readonly);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();\n});")), this.rule().condition(this.type("entity"), this.trigger("init")).output(this.mark("name", "firstLowerCase")).output(this.literal(".onShow(e -> {\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.onRemove(removeListener);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.onDirty(dirty -> canClose(!dirty));\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.backInfo(backTitle, backAddressResolver, backListener);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.room(room, roomName);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.section(section);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.location(location);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.entity(EntitySetDatasource.itemOf(entity));\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.view(view);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.readonly(readonly);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();\n});")), this.rule().condition(this.allTypes("ui", "permissions"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class PermissionsTemplate extends AbstractPermissionsTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n\n    public PermissionsTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        homeLink.onExecute(e -> notifier.redirect(centerUrl()));\n        logoutButton.onExecute(e -> {\n            session().logout();\n            if (box().authService() != null) box().authService().logout(null);\n            box().provider(session()).logout();\n            notifier.redirect(box().authService() != null ? box().authService().logoutUrl() : session().browser().baseUrl() + \"/login\");\n        });\n        refresh();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        TGSessionInfo sessionInfo = box().provider(session()).loginCAS(io.intino.goros.egeasy.provider.Provider.webToken(), username());\n        description.value(sessionInfo != null ? sessionInfo.getErrorMessage() : null);\n    }\n\n    private String centerUrl() {\n        String url = box().configuration().url();\n        url = url != null && url.endsWith(\"/\") ? url.substring(0, url.length()-1) : url;\n        url = url != null && url.lastIndexOf(\"/\") != -1 ? url.substring(0, url.lastIndexOf(\"/\")) : null;\n        return url != null && !url.equals(\"http:/\") && !url.equals(\"https:/\") ? url : session().browser().baseUrl();\n    }\n}")), this.rule().condition(this.allTypes("entity", "task"), this.trigger("refresh")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && view != null && view.equals(\"form\")) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".show(); return; }")), this.rule().condition(this.type("entity"), this.trigger("refresh")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(") { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".show(); return; }")), this.rule().condition(this.type("entity"), this.trigger("hide")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".hide(); }")), this.rule().condition(this.type("entity"), this.trigger("dirty")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { return ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.dirty(); }")), this.rule().condition(this.type("entity"), this.trigger("selectview")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.selectView(view);")), this.rule().condition(this.type("entity"), this.trigger("drcdeclaration")).output(this.mark("drc", new String[0])), this.rule().condition(this.type("entity"), this.trigger("endedition")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.endEdition(); return; }")), this.rule().condition(this.type("entity"), this.trigger("opensavedialog")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.openSaveDialog(listener); return; }")), this.rule().condition(this.type("entity"), this.trigger("save")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible() && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.dirty()) { return ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.save(); }")), this.rule().condition(this.type("entity"), this.trigger("silentsave")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { return ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.silentSave(); }")), this.rule().condition(this.type("entity"), this.trigger("forcesave")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.forceSave(); }")), this.rule().condition(this.type("entity"), this.trigger("validateerrors")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.showValidationErrors(errors); return; }")), this.rule().condition(this.type("room"), this.trigger("processes")).output(this.literal("put(\"")).output(this.mark("name", "firstLowerCase")).output(this.literal("\", new HashMap<>() {{ ")).output(this.mark("process", new String[0]).multiple(" ")).output(this.literal(" }});")), this.rule().condition(this.type("room"), this.trigger("refresh")).output(this.literal("if (habitaciones.")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) habitaciones.")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();")), this.rule().condition(this.type("process"), new Rule.Condition[0]).output(this.literal("put(")).output(this.mark("drc", new String[0])).output(this.literal(", \"")).output(this.mark("label", new String[0])).output(this.literal("\");")));
    }
}

