/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.configuration;

import io.intino.goros.egeasy.m3.configuration.DBConfiguration;
import io.intino.goros.egeasy.m3.configuration.DBType;
import io.intino.goros.egeasy.m3.configuration.EGEConfiguration;
import io.intino.goros.egeasy.m3.entity.TGVariant;
import io.intino.goros.egeasy.m3.serializer.ESerializerException;
import io.intino.goros.egeasy.m3.serializer.SerializedInputStream;
import io.intino.goros.egeasy.m3.serializer.SerializedOutputStream;
import java.io.IOException;

public class SerializerConfigurationBinary {
    public void serializeValue(Object target, SerializedOutputStream stream) throws IOException {
    }

    public void unserializeValue(Object target, SerializedInputStream stream, int streamSize) throws IOException, ESerializerException {
        this.doUnserializeValue((EGEConfiguration)target, stream);
    }

    private void doUnserializeValue(EGEConfiguration target, SerializedInputStream stream) throws IOException {
        try {
            TGVariant variantValue = stream.readFieldVariant("CenterName");
            target.setCenterName(variantValue.asString());
            variantValue = stream.readFieldVariant("ModelLocation");
            target.setModelLocation(variantValue.asString());
            variantValue = stream.readFieldVariant("RegistryLocation");
            target.setRegistryLocation(variantValue.asString());
            variantValue = stream.readFieldVariant("DocumentLocation");
            target.setDocumentLocation(variantValue.asString());
            variantValue = stream.readFieldVariant("DBConnectionJava");
            this.loadDBConfiguration(target.getDbConfiguration(), variantValue.asString());
            variantValue = stream.readFieldVariant("DBType");
            target.getDbConfiguration().setType(DBType.tdbOracle);
            variantValue = stream.readFieldVariant("DataConnections");
            target.getDbConfiguration().setNumConnections(variantValue.asInt());
            variantValue = stream.readFieldVariant("DBConnectionJava");
            target.getEgSystemWebConnection().setUrl(variantValue.asString());
            variantValue = stream.readFieldVariant("SystemWebPort");
            target.getEgSystemWebConnection().setPort(variantValue.asInt());
            variantValue = stream.readFieldVariant("SystemWebProtocol");
            target.getEgSystemWebConnection().setBinderType(variantValue.asString());
            variantValue = stream.readFieldVariant("CasEnabled");
            target.getCasConfiguration().setActive(variantValue.asBoolean());
            variantValue = stream.readFieldVariant("CasUrl");
            target.getCasConfiguration().setUrl(variantValue.asString());
            variantValue = stream.readFieldVariant("EsbUrl");
            target.getEsbConfiguration().setUrl(variantValue.asString());
            variantValue = stream.readFieldVariant("EsbTimeout");
            target.getEsbConfiguration().setTimeout(variantValue.asInt());
            variantValue = stream.readFieldVariant("Variables");
            target.getVariables();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadDBConfiguration(DBConfiguration dbConfiguration, String connectionString) {
        String[] parts = connectionString.split("@");
        if (parts.length < 3) {
            return;
        }
        dbConfiguration.setUsername(parts[0]);
        dbConfiguration.setPassword(parts[2]);
        dbConfiguration.setHost(parts[1]);
    }

    public void serialize(Object target, SerializedOutputStream stream) throws IOException {
        stream.openWrite();
        try {
            this.serializeValue(target, stream);
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unserialize(Object target, SerializedInputStream stream, int streamSize) throws IOException, ESerializerException {
        try {
            stream.openRead(streamSize);
            try {
                this.unserializeValue(target, stream, streamSize);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new ESerializerException("Excepci\u00f3n al leer la configuracion.", e);
        }
    }
}

