/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.utils;

import io.intino.goros.egeasy.m3.definition.base.DefType;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.ListDefinitions;
import io.intino.goros.egeasy.m3.definition.dictionary.Dictionary;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DefinitionUtils {
    private static Boolean checkDefinitionRoot(Definition definition, DefType root) {
        if (definition == null) {
            return false;
        }
        Definition defRoot = definition.getRoot();
        return defRoot instanceof DefType && defRoot == root;
    }

    public static Boolean isContainerDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTContainer);
    }

    public static Boolean isTaskDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTTask);
    }

    public static Boolean isRoomDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTRoom);
    }

    public static Boolean isFormDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTForm);
    }

    public static Boolean isSectionDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTSection);
    }

    public static Boolean isFieldDefinition(Definition definition) {
        Definition defRoot = definition.getRoot();
        return defRoot != null && defRoot.getDRC() > Metamodel.DRC_TYPE_FIELD && defRoot.getDRC() < Metamodel.DRC_TYPE_DECLARATION;
    }

    public static Boolean isFieldReferenceDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTReference);
    }

    public static Boolean isColumnDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTColumn);
    }

    public static Boolean isCollectionDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTCollection);
    }

    public static Boolean isCatalogDefinition(Definition definition) {
        return DefinitionUtils.checkDefinitionRoot(definition, Metamodel.getInstance().DTCatalog);
    }

    public static String getDefinitionAttributeValue(Definition definition, String attribute) {
        if (definition == null) {
            return "";
        }
        List<String> attributes = definition.getAttributes().findAttribute(attribute);
        return attributes.isEmpty() ? "" : attributes.get(0);
    }

    public static String extractDefinitionName(String name) {
        int pos = name.indexOf("::");
        return pos > 0 ? name.substring(pos + 2) : name;
    }

    public static List<Definition> sortedDefinitions(Definition definition) {
        return definition.getDefinitions().stream().sorted((o1, o2) -> Integer.compare(o2.order(), o1.order())).collect(Collectors.toList());
    }

    public static List<Definition> visibleAndSortedDefinitions(Definition definition) {
        return DefinitionUtils.visibleAndSortedDefinitions(definition.getDefinitions());
    }

    public static List<Definition> visibleAndSortedDefinitions(ListDefinitions definitions) {
        return definitions.stream().filter(Definition::isVisible).sorted((o1, o2) -> Integer.compare(o2.order(), o1.order())).collect(Collectors.toList());
    }

    public static List<Definition> visibleAndSortedDefinitions(List<Definition> definitions) {
        return definitions.stream().filter(Definition::isVisible).sorted((o1, o2) -> Integer.compare(o2.order(), o1.order())).collect(Collectors.toList());
    }

    public static List<String> newProcessDefinitionsOptions(Definition room, Definition container) {
        return DefinitionUtils.newProcessDefinitions(room, container).stream().map(Definition::getName).collect(Collectors.toList());
    }

    public static Definition newProcessDefinition(Definition room, Definition container, String label) {
        return DefinitionUtils.newProcessDefinitions(room, container).stream().filter(d -> d.getName().equals(label)).findFirst().orElse(null);
    }

    public static List<Definition> newProcessDefinitions(Definition room, Definition container) {
        List<Definition> listProcessRoom = DefinitionUtils.fillDefProcessesOfResource(room);
        List<Definition> listProcessContainer = DefinitionUtils.fillDefProcessesOfResource(container);
        ArrayList<Definition> listProcess = new ArrayList<Definition>(listProcessRoom);
        listProcess.addAll(listProcessContainer);
        return listProcess;
    }

    private static List<Definition> fillDefProcessesOfResource(Definition definition) {
        List<String> attributes;
        List<String> list = attributes = definition != null ? definition.getAttributes().findAttribute("TAREAS") : Collections.emptyList();
        if (attributes == null) {
            return Collections.emptyList();
        }
        ArrayList<Definition> listDefProcess = new ArrayList<Definition>();
        for (String attribute : attributes) {
            int DRCTask = Integer.parseInt(attribute);
            Definition defProcess = Dictionary.getInstance().findDefinition(DRCTask);
            if (!DefinitionUtils.isProcessDefinition(defProcess) || DefinitionUtils.isAbstractDefinition(defProcess) || !LibraryDefinitions.getAtActive(defProcess) || listDefProcess.contains(defProcess)) continue;
            listDefProcess.add(defProcess);
        }
        return listDefProcess;
    }

    private static boolean isProcessDefinition(Definition def) {
        List<String> attributes = def.getAttributes().findAttribute("ES_RAIZ");
        if (attributes.isEmpty()) {
            return false;
        }
        String value = attributes.get(0);
        return value.equals("S");
    }

    public static boolean isAbstractDefinition(Definition def) {
        if (!(def instanceof DefType)) {
            return false;
        }
        return ((DefType)def).getAbstract();
    }

    public static boolean hasTaskFields(Definition definition) {
        return DefinitionUtils.visibleAndSortedDefinitions(definition).stream().anyMatch(DefinitionUtils::isFieldDefinition);
    }
}

