/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules;

import io.intino.itrules.Adapter;
import io.intino.itrules.Formatter;
import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.TemplateEngine;
import io.intino.itrules.rules.conditions.AttributeCondition;
import io.intino.itrules.rules.conditions.NegatedCondition;
import io.intino.itrules.rules.conditions.TriggerCondition;
import io.intino.itrules.rules.conditions.TypeCondition;
import io.intino.itrules.rules.output.Expression;
import io.intino.itrules.rules.output.Literal;
import io.intino.itrules.rules.output.Mark;

public abstract class Template {
    private TemplateEngine engine;

    public Template() {
        this(new TemplateEngine.Configuration());
    }

    public Template(TemplateEngine.Configuration configuration) {
        this.engine = new TemplateEngine(this.ruleSet(), configuration);
    }

    public Template add(String name, Formatter formatter) {
        this.engine.add(name, formatter);
        return this;
    }

    public <T> Template add(Class<T> class_, Adapter<T> adapter) {
        this.engine.add(class_, adapter);
        return this;
    }

    public String render(Object object) {
        this.init(this.engine);
        return this.engine.render(object);
    }

    protected void init(TemplateEngine engine) {
    }

    protected abstract RuleSet ruleSet();

    protected Rule rule() {
        return new Rule();
    }

    protected Rule.Condition not(Rule.Condition condition) {
        return new NegatedCondition(condition);
    }

    protected Rule.Condition attribute(String attribute) {
        return new AttributeCondition(attribute);
    }

    protected Rule.Condition attribute(String attribute, Object value) {
        return new AttributeCondition(attribute, value);
    }

    protected Rule.Condition type(String type) {
        return new TypeCondition(TypeCondition.Operator.Any, type);
    }

    protected Rule.Condition anyTypes(String ... types) {
        return new TypeCondition(TypeCondition.Operator.Any, types);
    }

    protected Rule.Condition allTypes(String ... types) {
        return new TypeCondition(TypeCondition.Operator.All, types);
    }

    protected Rule.Condition trigger(String name) {
        return new TriggerCondition(name);
    }

    protected Mark mark(String name, String ... formatters) {
        return new Mark(name, formatters);
    }

    protected Literal literal(String text) {
        return new Literal(text);
    }

    protected Expression expression(Rule.Output ... outputs) {
        return new Expression(outputs);
    }
}

