/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.util;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.modernizing.egeasy.util.RegistryGenerator;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.HashMap;

public class GeneratorUtils {
    public static HashMap<String, String> textToReplace = new HashMap();

    public static String toCamelCase(String s) {
        s = s.replaceAll("::", "_");
        s = Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        String[] parts = s.split(" ");
        Object camelCaseString = "";
        for (String part : parts) {
            camelCaseString = (String)camelCaseString + GeneratorUtils.toCamelProperCase(part);
        }
        return camelCaseString;
    }

    public static String toCamelProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String getClassName(Definition definition) {
        if (definition == null) {
            return null;
        }
        String label = RegistryGenerator.getInstance().getClass(definition.getDRC());
        return label != null ? label : GeneratorUtils.getClassName(definition.getName());
    }

    public static String normalizeClassName(String label) {
        label = label.replace(" de ", " ");
        label = label.replace(" y ", " ");
        label = label.replace(" a ", " ");
        label = label.replace(" el ", " ");
        label = label.replace(" la ", " ");
        for (String text : textToReplace.keySet()) {
            String value = textToReplace.get(text);
            label = label.replace(text, value);
        }
        return label;
    }

    public static String getClassName(String label) {
        return GeneratorUtils.toCamelCase(GeneratorUtils.normalizeClassName(label));
    }

    public static String getVariableName(String label) {
        String camelCase = GeneratorUtils.toCamelCase(GeneratorUtils.normalizeClassName(label));
        return camelCase.substring(0, 1).toLowerCase() + camelCase.substring(1);
    }

    public static String composePackage(String rootPackage, String newPackage) {
        return rootPackage + "." + newPackage;
    }

    public static boolean saveFileContent(String filePath, String fileContent) {
        try {
            Files.write(Paths.get(filePath, new String[0]), fileContent.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getTemplateKonosIconValue(String iconValue) {
        return iconValue.equals("") ? "" : "/icons/" + iconValue;
    }

    public static String getKonosTemplateValue(String templateName) {
        return templateName.toLowerCase() + "Template";
    }

    public static String getKonosCollectionValue(String templateName) {
        return templateName + "Table";
    }

    public static String getKonosColumnHeadingValue(String templateName, String columnName) {
        return templateName + columnName + "Heading";
    }

    public static String getKonosColumnViewNameValue(String templateName, String columnName) {
        return templateName + columnName + "View";
    }

    public static String getKonosColumnNameValue(String columnLabel) {
        return GeneratorUtils.getClassName(columnLabel);
    }

    static {
        textToReplace.put("(", "_");
        textToReplace.put(")", "_");
        textToReplace.put("[", "_");
        textToReplace.put("]", "_");
        textToReplace.put("/", "");
        textToReplace.put("-", "");
        textToReplace.put("+", "");
        textToReplace.put(",", "");
        textToReplace.put(";", "");
        textToReplace.put("\u00ba", "");
        textToReplace.put("\u00aa", "");
        textToReplace.put("::", "_");
        textToReplace.put("\u00e1", "a");
        textToReplace.put("\u00e9", "e");
        textToReplace.put("\u00ed", "i");
        textToReplace.put("\u00f3", "o");
        textToReplace.put("\u00fa", "u");
        textToReplace.put("\u00c1", "A");
        textToReplace.put("\u00c9", "E");
        textToReplace.put("\u00cd", "I");
        textToReplace.put("\u00d3", "O");
        textToReplace.put("\u00da", "U");
        textToReplace.put("\u00d1", "N");
        textToReplace.put("\u00f1", "n");
    }
}

