/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class FileServiceTemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.allTypes("fileservice", "getfileaction"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.actions;\n\nimport io.intino.alexandria.Resource;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.exceptions.BadRequest;\nimport io.intino.alexandria.exceptions.Forbidden;\nimport io.intino.alexandria.exceptions.NotFound;\nimport io.intino.goros.egeasy.provider.Provider;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.io.InputStream;\n\npublic class GetFileAction implements io.intino.alexandria.rest.RequestErrorHandler {\n    public String type;\n    public Integer rrc;\n    public Integer drc;\n    public Integer cdrc;\n    public Integer crow;\n    public String name;\n    public Integer id;\n    public Boolean signed;\n    public String session;\n    public ")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box;\n    public io.intino.alexandria.http.spark.SparkContext context;\n\n    public io.intino.alexandria.Resource execute() throws BadRequest, Forbidden, NotFound {\n        Provider provider = box.provider(session);\n        if (provider == null) throw new Forbidden(\"You don't have access to this file\");\n        InputStream result;\n        if (type.equals(\"document\")) result = provider.openDocumentFile(rrc, drc, cdrc, signed);\n        else if (isTable()) result = provider.openTableFile(id, signed);\n        else result = provider.openFieldFile(rrc, drc, cdrc, -1, signed);\n        return new Resource(name, result);\n    }\n\n    public void onMalformedRequest(Throwable e) throws AlexandriaException {\n        throw new BadRequest(\"Malformed request\");\n    }\n\n    private boolean isTable() {\n        return crow != null && crow != -1;\n    }\n}")));
    }
}

