/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.definition;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionLocation;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.definition.SetRenderer;
import io.intino.goros.modernizing.egeasy.renderers.templates.java.LocationTemplate;
import io.intino.goros.modernizing.egeasy.util.StringUtil;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import java.io.File;

public class LocationRenderer
extends SetRenderer<DefInstance> {
    public LocationRenderer(TreeNodeResource dictionary, Modernization modernization, DefInstance definition) {
        super(dictionary, modernization, definition);
    }

    private void write(DefInstance location) {
        this.factory.renderer(this.dictionary, this.modernization, location).write();
    }

    @Override
    public FrameBuilder buildFrame() {
        DefInstance definition = (DefInstance)this.definition();
        Definition definitionLocated = this.definitionLocated();
        FrameBuilder result = this.baseDefinitionFrame();
        result.add("location");
        result.add("place", this.placeOf(definition));
        result.add("icon", this.iconFrameOf(this.definitionLocated()));
        result.add("placeName", this.normalize(this.placeOf(definition)));
        this.addEntityTypes(definitionLocated, result);
        this.addRun(definition, definitionLocated, result);
        this.addSet(result, definition, definitionLocated, this.collectionDefinition(definitionLocated));
        return result;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.egeasy.renderers.templates.konos.LocationTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new LocationTemplate();
    }

    @Override
    protected void writeJava(FrameBuilder builder) {
        DefInstance definition = (DefInstance)this.definition();
        File file = new File(this.javaPackage() + StringUtil.firstUpperCase(this.normalize(this.placeOf(definition))) + this.nameOf(definition) + "Template.java");
        this.writeFrame(file, this.javaTemplate().render(builder.toFrame()));
    }

    @Override
    protected void writeKonos(FrameBuilder builder) {
        DefInstance definition = (DefInstance)this.definition();
        File file = new File(this.konosPackage() + StringUtil.firstUpperCase(this.normalize(this.placeOf(definition))) + this.nameOf(definition) + ".konos");
        this.writeFrame(file, this.konosTemplate().render(builder.toFrame()));
    }

    private Definition collectionDefinition(Definition definition) {
        return definition.getDefinitions().stream().filter(d -> DefinitionUtils.isCollectionDefinition(d) != false || DefinitionUtils.isCatalogDefinition(d) != false).findFirst().orElse(null);
    }

    private Definition definitionLocated() {
        return ((DefinitionExtensionLocation)((DefInstance)this.definition()).getExtension()).getDefinitionLocated();
    }
}

