/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gepetoclient;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache {
    private final int capacity;
    private final LinkedHashMap<String, String> map;

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.map = new LinkedHashMap<String, String>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > LRUCache.this.capacity;
            }
        };
    }

    public synchronized String get(String key) {
        return this.map.getOrDefault(key, null);
    }

    public synchronized void put(String key, String value) {
        this.map.put(key, value);
    }
}

