/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gepetoclient;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.gepetoclient.LRUCache;
import java.net.URL;

public class GepetoAccessor {
    private final URL url;
    private final int timeoutMillis;
    private final LRUCache cache;

    public GepetoAccessor(URL url) {
        this(url, 120000);
    }

    public GepetoAccessor(URL url, int timeoutMillis) {
        this(url, timeoutMillis, 0);
    }

    public GepetoAccessor(URL url, int timeoutMillis, int cacheSize) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.cache = cacheSize > 0 ? new LRUCache(cacheSize) : null;
    }

    public String postTranslation(String text, String languageCode) throws InternalServerError {
        String response;
        if (this.cache != null && (response = this.cache.get(languageCode + "%%$$%%" + text)) != null) {
            return response;
        }
        try {
            RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).entityPart("text", (Object)text).headerParameter("languageCode", (Object)languageCode).build(RequestBuilder.Method.POST, "/api/translations");
            String response2 = (String)ResponseAdapter.adapt((String)request.execute().content(), String.class);
            if (this.cache != null) {
                this.cache.put(languageCode + "%%$$%%" + text, response2);
            }
            return response2;
        }
        catch (AlexandriaException e) {
            throw new InternalServerError(e.message());
        }
    }

    public String postPrompts(String prompt) throws InternalServerError {
        try {
            String response;
            if (this.cache != null && (response = this.cache.get(prompt)) != null) {
                return response;
            }
            RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).entityPart("prompt", (Object)prompt).build(RequestBuilder.Method.POST, "/api/prompts");
            String response2 = (String)ResponseAdapter.adapt((String)request.execute().content(), String.class);
            if (this.cache != null) {
                this.cache.put(prompt, response2);
            }
            return response2;
        }
        catch (AlexandriaException e) {
            throw new InternalServerError(e.message());
        }
    }
}

