/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.model;

import io.intino.gamification.core.model.Component;
import io.intino.gamification.core.model.Item;
import java.util.List;
import java.util.stream.Collectors;

public class Player
extends Component {
    private final String worldId;
    private final boolean enabled;
    private final double health;
    private final List<String> groups;
    private final int score;
    private final List<Item> inventory;
    private final List<AchievementState> achievements;
    private final Integer level;

    public Player(io.intino.gamification.core.graph.Player player) {
        super(player.id());
        this.worldId = player.worldId();
        this.enabled = player.enabled();
        this.health = player.health();
        this.groups = player.groups();
        this.score = player.score();
        this.inventory = player.inventory().stream().map(Item::new).collect(Collectors.toList());
        this.achievements = player.achievements().stream().map(AchievementState::new).collect(Collectors.toList());
        this.level = player.level();
    }

    public String worldId() {
        return this.worldId;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public double health() {
        return this.health;
    }

    public List<String> groups() {
        return this.groups;
    }

    public int score() {
        return this.score;
    }

    public List<Item> inventory() {
        return this.inventory;
    }

    public List<AchievementState> achievements() {
        return this.achievements;
    }

    public Integer level() {
        return this.level;
    }

    private static class AchievementState {
        private final String achievementId;
        private final io.intino.gamification.core.model.attributes.AchievementState state;
        private final int count;

        public AchievementState(io.intino.gamification.core.graph.AchievementState achievementState) {
            this.achievementId = achievementState.achievementId();
            this.state = achievementState.state();
            this.count = achievementState.count();
        }

        public String missionId() {
            return this.achievementId;
        }

        public io.intino.gamification.core.model.attributes.AchievementState state() {
            return this.state;
        }

        public int count() {
            return this.count;
        }
    }
}

