/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.model;

import io.intino.gamification.core.box.checkers.CheckerHandler;
import io.intino.gamification.core.box.events.EventType;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.model.Component;
import io.intino.gamification.core.model.attributes.MissionDifficulty;
import io.intino.gamification.core.model.attributes.MissionType;
import java.time.Instant;
import java.util.List;
import java.util.function.Consumer;

public class Mission
extends Component {
    private final String description;
    private final MissionType type;
    private final MissionDifficulty difficulty;
    private final Instant expiration;
    private final EventType eventInvolved;
    private final int maxCount;
    private final List<String> playersId;
    private final transient Consumer<CheckerHandler.Checker<? extends GamificationEvent>> progressCosumer;

    public Mission(io.intino.gamification.core.graph.Mission mission) {
        super(mission.id());
        this.description = mission.description();
        this.type = mission.type();
        this.difficulty = mission.difficulty();
        this.expiration = mission.expiration();
        this.eventInvolved = mission.eventInvolved();
        this.maxCount = mission.maxCount();
        this.playersId = mission.players();
        this.progressCosumer = checker -> CheckerHandler.progressIf(mission, checker);
    }

    public String description() {
        return this.description;
    }

    public MissionType type() {
        return this.type;
    }

    public MissionDifficulty difficulty() {
        return this.difficulty;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public EventType eventInvolved() {
        return this.eventInvolved;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public List<String> playersId() {
        return this.playersId;
    }

    public <T extends GamificationEvent> void progressIf(CheckerHandler.Checker<T> checker) {
        this.progressCosumer.accept(checker);
    }
}

