/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.model;

import io.intino.gamification.core.model.Achievement;
import io.intino.gamification.core.model.Component;
import io.intino.gamification.core.model.Mission;
import io.intino.gamification.core.model.attributes.AchievementState;
import io.intino.gamification.core.model.attributes.MatchState;
import io.intino.gamification.core.model.attributes.MissionState;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class Match
extends Component {
    private final String worldId;
    private final Instant from;
    private final Instant to;
    private final MatchState state;
    private final boolean reboot;
    private final List<PlayerState> playersState;
    private final List<Mission> missions;
    private final List<Achievement> achievements;

    public Match(io.intino.gamification.core.graph.Match match) {
        super(match.id());
        this.worldId = match.worldId();
        this.from = match.from();
        this.to = match.to();
        this.state = match.state();
        this.reboot = match.reboot();
        this.playersState = match.playersState().stream().map(PlayerState::new).collect(Collectors.toList());
        this.missions = match.missions().stream().map(Mission::new).collect(Collectors.toList());
        this.achievements = match.achievements().stream().map(Achievement::new).collect(Collectors.toList());
    }

    public String worldId() {
        return this.worldId;
    }

    public Instant from() {
        return this.from;
    }

    public Instant to() {
        return this.to;
    }

    public MatchState state() {
        return this.state;
    }

    public boolean reboot() {
        return this.reboot;
    }

    public List<PlayerState> playersState() {
        return this.playersState;
    }

    public List<Mission> missions() {
        return this.missions;
    }

    public List<Achievement> achievements() {
        return this.achievements;
    }

    public static class PlayerState {
        private final String playerId;
        private final int score;
        private final List<MissionState> missionsState;
        private final List<AchievementState> achievementsState;

        public PlayerState(io.intino.gamification.core.graph.PlayerState playerState) {
            this.playerId = playerState.playerId();
            this.score = playerState.score();
            this.missionsState = playerState.missionState().stream().map(MissionState::new).collect(Collectors.toList());
            this.achievementsState = playerState.achievements().stream().map(AchievementState::new).collect(Collectors.toList());
        }

        public String playerId() {
            return this.playerId;
        }

        public int score() {
            return this.score;
        }

        public List<MissionState> missionsState() {
            return this.missionsState;
        }

        public List<AchievementState> achievementsState() {
            return this.achievementsState;
        }

        public static class AchievementState {
            private final String achievementId;
            private final io.intino.gamification.core.model.attributes.AchievementState state;
            private final int count;

            public AchievementState(io.intino.gamification.core.graph.AchievementState achievementState) {
                this.achievementId = achievementState.achievementId();
                this.state = achievementState.state();
                this.count = achievementState.count();
            }

            public String missionId() {
                return this.achievementId;
            }

            public io.intino.gamification.core.model.attributes.AchievementState state() {
                return this.state;
            }

            public int count() {
                return this.count;
            }
        }

        public static class MissionState {
            private final String missionId;
            private final io.intino.gamification.core.model.attributes.MissionState state;
            private final int count;

            public MissionState(io.intino.gamification.core.graph.MissionState missionState) {
                this.missionId = missionState.missionId();
                this.state = missionState.state();
                this.count = missionState.count();
            }

            public String missionId() {
                return this.missionId;
            }

            public io.intino.gamification.core.model.attributes.MissionState state() {
                return this.state;
            }

            public int count() {
                return this.count;
            }
        }
    }
}

