/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.model;

import io.intino.gamification.core.box.checkers.CheckerHandler;
import io.intino.gamification.core.box.events.EventType;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.model.Component;
import java.util.function.Consumer;

public class Achievement
extends Component {
    private final String description;
    private final EventType eventInvolved;
    private final int maxCount;
    private final Consumer<CheckerHandler.Checker<? extends GamificationEvent>> progressConsumer;

    public Achievement(io.intino.gamification.core.graph.Achievement achievement) {
        super(achievement.id());
        this.description = achievement.description();
        this.eventInvolved = achievement.eventInvolved();
        this.maxCount = achievement.maxCount();
        this.progressConsumer = checker -> CheckerHandler.progressIf(achievement, checker);
    }

    public String description() {
        return this.description;
    }

    public EventType eventInvolved() {
        return this.eventInvolved;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public <T extends GamificationEvent> void progressIf(CheckerHandler.Checker<T> checker) {
        this.progressConsumer.accept(checker);
    }
}

