/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.launcher;

import io.intino.alexandria.logger.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Async {
    protected final ExecutorService thread = Executors.newSingleThreadExecutor(this::createThread);
    protected final AtomicBoolean running = new AtomicBoolean();
    protected Runnable onStart = () -> {};

    protected Thread createThread(Runnable runnable) {
        return new Thread(runnable, this.getClass().getSimpleName() + "-Thread");
    }

    public void onStart(Runnable onStartCallback) {
        this.onStart = onStartCallback != null ? onStartCallback : () -> {};
    }

    public Future<?> start() {
        if (!this.running.compareAndSet(false, true)) {
            Logger.warn("Model " + this.hashCode() + " is already running");
            return null;
        }
        return this.thread.submit(this::run);
    }

    public boolean running() {
        return this.running.get();
    }

    public boolean stop() {
        return this.stop(0L, TimeUnit.SECONDS);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        if (!this.running.compareAndSet(true, false)) {
            return false;
        }
        try {
            this.thread.shutdown();
            this.thread.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
        return true;
    }

    protected abstract void run();
}

