/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.AchievementState;
import io.intino.gamification.core.graph.CoreGraph;
import io.intino.gamification.core.graph.MissionState;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PlayerState
extends Layer
implements Terminal {
    protected String playerId;
    protected int score;
    protected List<MissionState> missionState = new ArrayList<MissionState>();
    protected List<AchievementState> achievements = new ArrayList<AchievementState>();

    public PlayerState(Node node) {
        super(node);
    }

    public String playerId() {
        return this.playerId;
    }

    public int score() {
        return this.score;
    }

    public List<MissionState> missionState() {
        return this.missionState;
    }

    public MissionState missionState(int index) {
        return this.missionState.get(index);
    }

    public List<MissionState> missionState(Predicate<MissionState> predicate) {
        return this.missionState().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<AchievementState> achievements() {
        return this.achievements;
    }

    public AchievementState achievements(int index) {
        return this.achievements.get(index);
    }

    public List<AchievementState> achievements(Predicate<AchievementState> predicate) {
        return this.achievements().stream().filter(predicate).collect(Collectors.toList());
    }

    public PlayerState playerId(String value) {
        this.playerId = value;
        return this;
    }

    public PlayerState score(int value) {
        this.score = value;
        return this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("playerId", new ArrayList<String>(Collections.singletonList(this.playerId)));
        map.put("score", new ArrayList<Integer>(Collections.singletonList(this.score)));
        map.put("missionState", this.missionState);
        map.put("achievements", this.achievements);
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("playerId")) {
            this.playerId = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("score")) {
            this.score = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("missionState")) {
            this.missionState = NodeLoader.load(values, MissionState.class, this);
        } else if (name.equalsIgnoreCase("achievements")) {
            this.achievements = NodeLoader.load(values, AchievementState.class, this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("playerId")) {
            this.playerId = (String)values.get(0);
        } else if (name.equalsIgnoreCase("score")) {
            this.score = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("missionState")) {
            this.missionState = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(MissionState.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("achievements")) {
            this.achievements = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(AchievementState.class)).collect(Collectors.toList());
        }
    }

    public CoreGraph graph() {
        return this.core$().graph().as(CoreGraph.class);
    }
}

