/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.box.checkers.CheckResult;
import io.intino.gamification.core.box.checkers.CheckerHandler;
import io.intino.gamification.core.box.events.EventType;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.utils.TimeUtils;
import io.intino.gamification.core.graph.AbstractMission;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.model.attributes.MissionDifficulty;
import io.intino.gamification.core.model.attributes.MissionType;
import io.intino.magritte.framework.Node;

public class Mission
extends AbstractMission {
    public Mission(Node node) {
        super(node);
    }

    public MissionDifficulty difficulty() {
        return MissionDifficulty.valueOf(this.difficultyName);
    }

    public MissionType type() {
        return MissionType.valueOf(this.typeName);
    }

    public EventType eventInvolved() {
        return EventType.valueOf(this.eventInvolvedName);
    }

    public AbstractMission difficulty(MissionDifficulty difficulty) {
        this.difficultyName(difficulty.name());
        return this;
    }

    public AbstractMission type(MissionType type) {
        this.typeName(type.name());
        return this;
    }

    public AbstractMission eventInvolved(EventType event) {
        this.eventInvolvedName(event.name());
        return this;
    }

    public CheckResult check(GamificationEvent event, Player player) {
        return CheckerHandler.check(this, event, player);
    }

    public <T extends GamificationEvent> void progressIf(CheckerHandler.Checker<T> checker) {
        CheckerHandler.progressIf(this, checker);
    }

    public boolean isActive() {
        return this.expiration == null || this.expiration.isAfter(TimeUtils.currentInstant());
    }
}

