/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.Context;
import io.intino.gamification.core.graph.CoreGraph;
import io.intino.gamification.core.graph.Item;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Npc;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.World;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractWorld
extends Context
implements Terminal {
    protected List<Player> players = new ArrayList<Player>();
    protected List<Npc> npcs = new ArrayList<Npc>();
    protected List<Item> items = new ArrayList<Item>();
    protected Match match;

    public AbstractWorld(Node node) {
        super(node);
    }

    @Override
    public List<Player> players() {
        return this.players;
    }

    public Player players(int index) {
        return this.players.get(index);
    }

    public List<Player> players(Predicate<Player> predicate) {
        return this.players().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Npc> npcs() {
        return this.npcs;
    }

    public Npc npcs(int index) {
        return this.npcs.get(index);
    }

    public List<Npc> npcs(Predicate<Npc> predicate) {
        return this.npcs().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Item> items() {
        return this.items;
    }

    public Item items(int index) {
        return this.items.get(index);
    }

    public List<Item> items(Predicate<Item> predicate) {
        return this.items().stream().filter(predicate).collect(Collectors.toList());
    }

    public Match match() {
        return this.match;
    }

    public World match(Match value) {
        this.match = value;
        return (World)this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("players", this.players);
        map.put("npcs", this.npcs);
        map.put("items", this.items);
        map.put("match", this.match != null ? new ArrayList<Match>(Collections.singletonList(this.match)) : Collections.emptyList());
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("players")) {
            this.players = NodeLoader.load(values, Player.class, this);
        } else if (name.equalsIgnoreCase("npcs")) {
            this.npcs = NodeLoader.load(values, Npc.class, this);
        } else if (name.equalsIgnoreCase("items")) {
            this.items = NodeLoader.load(values, Item.class, this);
        } else if (name.equalsIgnoreCase("match")) {
            this.match = NodeLoader.load(values, Match.class, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("players")) {
            this.players = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Player.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("npcs")) {
            this.npcs = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Npc.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("items")) {
            this.items = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Item.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("match")) {
            this.match = values.get(0) != null ? this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Match.class) : null;
        }
    }

    @Override
    public CoreGraph graph() {
        return this.core$().graph().as(CoreGraph.class);
    }
}

