/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.AchievementState;
import io.intino.gamification.core.graph.CoreGraph;
import io.intino.gamification.core.graph.Entity;
import io.intino.gamification.core.graph.Item;
import io.intino.gamification.core.graph.Player;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractPlayer
extends Entity
implements Terminal {
    protected int score;
    protected List<Item> inventory = new ArrayList<Item>();
    protected List<AchievementState> achievements = new ArrayList<AchievementState>();

    public AbstractPlayer(Node node) {
        super(node);
    }

    public int score() {
        return this.score;
    }

    public List<Item> inventory() {
        return this.inventory;
    }

    public Item inventory(int index) {
        return this.inventory.get(index);
    }

    public List<Item> inventory(Predicate<Item> predicate) {
        return this.inventory().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<AchievementState> achievements() {
        return this.achievements;
    }

    public AchievementState achievements(int index) {
        return this.achievements.get(index);
    }

    public List<AchievementState> achievements(Predicate<AchievementState> predicate) {
        return this.achievements().stream().filter(predicate).collect(Collectors.toList());
    }

    public Player score(int value) {
        this.score = value;
        return (Player)this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("score", new ArrayList<Integer>(Collections.singletonList(this.score)));
        map.put("inventory", this.inventory);
        map.put("achievements", this.achievements);
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("score")) {
            this.score = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("inventory")) {
            this.inventory = NodeLoader.load(values, Item.class, this);
        } else if (name.equalsIgnoreCase("achievements")) {
            this.achievements = NodeLoader.load(values, AchievementState.class, this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("score")) {
            this.score = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("inventory")) {
            this.inventory = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Item.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("achievements")) {
            this.achievements = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(AchievementState.class)).collect(Collectors.toList());
        }
    }

    @Override
    public CoreGraph graph() {
        return this.core$().graph().as(CoreGraph.class);
    }
}

