/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.CoreGraph;
import io.intino.gamification.core.graph.Mission;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.InstantLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractMission
extends Layer
implements Terminal {
    protected String id;
    protected Instant expiration;
    protected List<String> players = new ArrayList<String>();
    protected String difficultyName;
    protected String typeName;
    protected String description;
    protected String eventInvolvedName;
    protected int maxCount;

    public AbstractMission(Node node) {
        super(node);
    }

    public String id() {
        return this.id;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public List<String> players() {
        return this.players;
    }

    public String players(int index) {
        return this.players.get(index);
    }

    public List<String> players(Predicate<String> predicate) {
        return this.players().stream().filter(predicate).collect(Collectors.toList());
    }

    public String difficultyName() {
        return this.difficultyName;
    }

    public String typeName() {
        return this.typeName;
    }

    public String description() {
        return this.description;
    }

    public String eventInvolvedName() {
        return this.eventInvolvedName;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public Mission id(String value) {
        this.id = value;
        return (Mission)this;
    }

    public Mission expiration(Instant value) {
        this.expiration = value;
        return (Mission)this;
    }

    public Mission difficultyName(String value) {
        this.difficultyName = value;
        return (Mission)this;
    }

    public Mission typeName(String value) {
        this.typeName = value;
        return (Mission)this;
    }

    public Mission description(String value) {
        this.description = value;
        return (Mission)this;
    }

    public Mission eventInvolvedName(String value) {
        this.eventInvolvedName = value;
        return (Mission)this;
    }

    public Mission maxCount(int value) {
        this.maxCount = value;
        return (Mission)this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("id", new ArrayList<String>(Collections.singletonList(this.id)));
        map.put("expiration", new ArrayList<Instant>(Collections.singletonList(this.expiration)));
        map.put("players", this.players);
        map.put("difficultyName", new ArrayList<String>(Collections.singletonList(this.difficultyName)));
        map.put("typeName", new ArrayList<String>(Collections.singletonList(this.typeName)));
        map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
        map.put("eventInvolvedName", new ArrayList<String>(Collections.singletonList(this.eventInvolvedName)));
        map.put("maxCount", new ArrayList<Integer>(Collections.singletonList(this.maxCount)));
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("expiration")) {
            this.expiration = InstantLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("players")) {
            this.players = StringLoader.load(values, this);
        } else if (name.equalsIgnoreCase("difficultyName")) {
            this.difficultyName = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("typeName")) {
            this.typeName = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("eventInvolvedName")) {
            this.eventInvolvedName = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("maxCount")) {
            this.maxCount = IntegerLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)values.get(0);
        } else if (name.equalsIgnoreCase("expiration")) {
            this.expiration = (Instant)values.get(0);
        } else if (name.equalsIgnoreCase("players")) {
            this.players = new ArrayList(values);
        } else if (name.equalsIgnoreCase("difficultyName")) {
            this.difficultyName = (String)values.get(0);
        } else if (name.equalsIgnoreCase("typeName")) {
            this.typeName = (String)values.get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)values.get(0);
        } else if (name.equalsIgnoreCase("eventInvolvedName")) {
            this.eventInvolvedName = (String)values.get(0);
        } else if (name.equalsIgnoreCase("maxCount")) {
            this.maxCount = (Integer)values.get(0);
        }
    }

    public CoreGraph graph() {
        return this.core$().graph().as(CoreGraph.class);
    }
}

