/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.Context;
import io.intino.gamification.core.graph.CoreGraph;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.PlayerState;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.InstantLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractMatch
extends Context
implements Terminal {
    protected String worldId;
    protected Instant from;
    protected Instant to;
    protected String stateName;
    protected boolean reboot;
    protected List<Mission> missions = new ArrayList<Mission>();
    protected List<PlayerState> playersState = new ArrayList<PlayerState>();

    public AbstractMatch(Node node) {
        super(node);
    }

    public String worldId() {
        return this.worldId;
    }

    public Instant from() {
        return this.from;
    }

    public Instant to() {
        return this.to;
    }

    public String stateName() {
        return this.stateName;
    }

    public boolean reboot() {
        return this.reboot;
    }

    public List<Mission> missions() {
        return this.missions;
    }

    public Mission missions(int index) {
        return this.missions.get(index);
    }

    public List<Mission> missions(Predicate<Mission> predicate) {
        return this.missions().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<PlayerState> playersState() {
        return this.playersState;
    }

    public PlayerState playersState(int index) {
        return this.playersState.get(index);
    }

    public List<PlayerState> playersState(Predicate<PlayerState> predicate) {
        return this.playersState().stream().filter(predicate).collect(Collectors.toList());
    }

    public Match worldId(String value) {
        this.worldId = value;
        return (Match)this;
    }

    public Match from(Instant value) {
        this.from = value;
        return (Match)this;
    }

    public Match to(Instant value) {
        this.to = value;
        return (Match)this;
    }

    public Match stateName(String value) {
        this.stateName = value;
        return (Match)this;
    }

    public Match reboot(boolean value) {
        this.reboot = value;
        return (Match)this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("worldId", new ArrayList<String>(Collections.singletonList(this.worldId)));
        map.put("from", new ArrayList<Instant>(Collections.singletonList(this.from)));
        map.put("to", new ArrayList<Instant>(Collections.singletonList(this.to)));
        map.put("stateName", new ArrayList<String>(Collections.singletonList(this.stateName)));
        map.put("reboot", new ArrayList<Boolean>(Collections.singletonList(this.reboot)));
        map.put("missions", this.missions);
        map.put("playersState", this.playersState);
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("worldId")) {
            this.worldId = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("from")) {
            this.from = InstantLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("to")) {
            this.to = InstantLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("stateName")) {
            this.stateName = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("reboot")) {
            this.reboot = BooleanLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("missions")) {
            this.missions = NodeLoader.load(values, Mission.class, this);
        } else if (name.equalsIgnoreCase("playersState")) {
            this.playersState = NodeLoader.load(values, PlayerState.class, this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("worldId")) {
            this.worldId = (String)values.get(0);
        } else if (name.equalsIgnoreCase("from")) {
            this.from = (Instant)values.get(0);
        } else if (name.equalsIgnoreCase("to")) {
            this.to = (Instant)values.get(0);
        } else if (name.equalsIgnoreCase("stateName")) {
            this.stateName = (String)values.get(0);
        } else if (name.equalsIgnoreCase("reboot")) {
            this.reboot = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("missions")) {
            this.missions = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Mission.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("playersState")) {
            this.playersState = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(PlayerState.class)).collect(Collectors.toList());
        }
    }

    @Override
    public CoreGraph graph() {
        return this.core$().graph().as(CoreGraph.class);
    }
}

