/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.Achievement;
import io.intino.gamification.core.graph.AchievementState;
import io.intino.gamification.core.graph.Context;
import io.intino.gamification.core.graph.Entity;
import io.intino.gamification.core.graph.Item;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.MissionState;
import io.intino.gamification.core.graph.Npc;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.PlayerState;
import io.intino.gamification.core.graph.World;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Context> contextList = new ArrayList<Context>();
    private List<World> worldList = new ArrayList<World>();
    private List<Match> matchList = new ArrayList<Match>();
    private List<Entity> entityList = new ArrayList<Entity>();
    private List<Player> playerList = new ArrayList<Player>();
    private List<Npc> npcList = new ArrayList<Npc>();
    private List<Item> itemList = new ArrayList<Item>();
    private List<PlayerState> playerStateList = new ArrayList<PlayerState>();
    private List<Mission> missionList = new ArrayList<Mission>();
    private List<MissionState> missionStateList = new ArrayList<MissionState>();
    private List<Achievement> achievementList = new ArrayList<Achievement>();
    private List<AchievementState> achievementStateList = new ArrayList<AchievementState>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("core");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("core");
        this.contextList = new ArrayList<Context>(wrapper.contextList);
        this.worldList = new ArrayList<World>(wrapper.worldList);
        this.matchList = new ArrayList<Match>(wrapper.matchList);
        this.entityList = new ArrayList<Entity>(wrapper.entityList);
        this.playerList = new ArrayList<Player>(wrapper.playerList);
        this.npcList = new ArrayList<Npc>(wrapper.npcList);
        this.itemList = new ArrayList<Item>(wrapper.itemList);
        this.playerStateList = new ArrayList<PlayerState>(wrapper.playerStateList);
        this.missionList = new ArrayList<Mission>(wrapper.missionList);
        this.missionStateList = new ArrayList<MissionState>(wrapper.missionStateList);
        this.achievementList = new ArrayList<Achievement>(wrapper.achievementList);
        this.achievementStateList = new ArrayList<AchievementState>(wrapper.achievementStateList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return this.core$().as(t);
    }

    @Override
    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    @Override
    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Context> contextList() {
        return this.contextList;
    }

    public List<World> worldList() {
        return this.worldList;
    }

    public List<Match> matchList() {
        return this.matchList;
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Player> playerList() {
        return this.playerList;
    }

    public List<Npc> npcList() {
        return this.npcList;
    }

    public List<Item> itemList() {
        return this.itemList;
    }

    public List<PlayerState> playerStateList() {
        return this.playerStateList;
    }

    public List<Mission> missionList() {
        return this.missionList;
    }

    public List<MissionState> missionStateList() {
        return this.missionStateList;
    }

    public List<Achievement> achievementList() {
        return this.achievementList;
    }

    public List<AchievementState> achievementStateList() {
        return this.achievementStateList;
    }

    public Stream<Context> contextList(Predicate<Context> filter) {
        return this.contextList.stream().filter(filter);
    }

    public Context context(int index) {
        return this.contextList.get(index);
    }

    public Stream<World> worldList(Predicate<World> filter) {
        return this.worldList.stream().filter(filter);
    }

    public World world(int index) {
        return this.worldList.get(index);
    }

    public Stream<Match> matchList(Predicate<Match> filter) {
        return this.matchList.stream().filter(filter);
    }

    public Match match(int index) {
        return this.matchList.get(index);
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Player> playerList(Predicate<Player> filter) {
        return this.playerList.stream().filter(filter);
    }

    public Player player(int index) {
        return this.playerList.get(index);
    }

    public Stream<Npc> npcList(Predicate<Npc> filter) {
        return this.npcList.stream().filter(filter);
    }

    public Npc npc(int index) {
        return this.npcList.get(index);
    }

    public Stream<Item> itemList(Predicate<Item> filter) {
        return this.itemList.stream().filter(filter);
    }

    public Item item(int index) {
        return this.itemList.get(index);
    }

    public Stream<PlayerState> playerStateList(Predicate<PlayerState> filter) {
        return this.playerStateList.stream().filter(filter);
    }

    public PlayerState playerState(int index) {
        return this.playerStateList.get(index);
    }

    public Stream<Mission> missionList(Predicate<Mission> filter) {
        return this.missionList.stream().filter(filter);
    }

    public Mission mission(int index) {
        return this.missionList.get(index);
    }

    public Stream<MissionState> missionStateList(Predicate<MissionState> filter) {
        return this.missionStateList.stream().filter(filter);
    }

    public MissionState missionState(int index) {
        return this.missionStateList.get(index);
    }

    public Stream<Achievement> achievementList(Predicate<Achievement> filter) {
        return this.achievementList.stream().filter(filter);
    }

    public Achievement achievement(int index) {
        return this.achievementList.get(index);
    }

    public Stream<AchievementState> achievementStateList(Predicate<AchievementState> filter) {
        return this.achievementStateList.stream().filter(filter);
    }

    public AchievementState achievementState(int index) {
        return this.achievementStateList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Context", new Indexer(node -> this.contextList.add(node.as(Context.class)), node -> this.contextList.remove(node.as(Context.class)), () -> this.contextList.clear()));
        map.put("World", new Indexer(node -> this.worldList.add(node.as(World.class)), node -> this.worldList.remove(node.as(World.class)), () -> this.worldList.clear()));
        map.put("Match", new Indexer(node -> this.matchList.add(node.as(Match.class)), node -> this.matchList.remove(node.as(Match.class)), () -> this.matchList.clear()));
        map.put("Entity", new Indexer(node -> this.entityList.add(node.as(Entity.class)), node -> this.entityList.remove(node.as(Entity.class)), () -> this.entityList.clear()));
        map.put("Player", new Indexer(node -> this.playerList.add(node.as(Player.class)), node -> this.playerList.remove(node.as(Player.class)), () -> this.playerList.clear()));
        map.put("Npc", new Indexer(node -> this.npcList.add(node.as(Npc.class)), node -> this.npcList.remove(node.as(Npc.class)), () -> this.npcList.clear()));
        map.put("Item", new Indexer(node -> this.itemList.add(node.as(Item.class)), node -> this.itemList.remove(node.as(Item.class)), () -> this.itemList.clear()));
        map.put("PlayerState", new Indexer(node -> this.playerStateList.add(node.as(PlayerState.class)), node -> this.playerStateList.remove(node.as(PlayerState.class)), () -> this.playerStateList.clear()));
        map.put("Mission", new Indexer(node -> this.missionList.add(node.as(Mission.class)), node -> this.missionList.remove(node.as(Mission.class)), () -> this.missionList.clear()));
        map.put("MissionState", new Indexer(node -> this.missionStateList.add(node.as(MissionState.class)), node -> this.missionStateList.remove(node.as(MissionState.class)), () -> this.missionStateList.clear()));
        map.put("Achievement", new Indexer(node -> this.achievementList.add(node.as(Achievement.class)), node -> this.achievementList.remove(node.as(Achievement.class)), () -> this.achievementList.clear()));
        map.put("AchievementState", new Indexer(node -> this.achievementStateList.add(node.as(AchievementState.class)), node -> this.achievementStateList.remove(node.as(AchievementState.class)), () -> this.achievementStateList.clear()));
        return map;
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
        public void world(Predicate<World> filter) {
            new ArrayList<World>(AbstractGraph.this.worldList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void match(Predicate<Match> filter) {
            new ArrayList<Match>(AbstractGraph.this.matchList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void player(Predicate<Player> filter) {
            new ArrayList<Player>(AbstractGraph.this.playerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void npc(Predicate<Npc> filter) {
            new ArrayList<Npc>(AbstractGraph.this.npcList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void item(Predicate<Item> filter) {
            new ArrayList<Item>(AbstractGraph.this.itemList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void playerState(Predicate<PlayerState> filter) {
            new ArrayList<PlayerState>(AbstractGraph.this.playerStateList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void mission(Predicate<Mission> filter) {
            new ArrayList<Mission>(AbstractGraph.this.missionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void missionState(Predicate<MissionState> filter) {
            new ArrayList<MissionState>(AbstractGraph.this.missionStateList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void achievement(Predicate<Achievement> filter) {
            new ArrayList<Achievement>(AbstractGraph.this.achievementList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void achievementState(Predicate<AchievementState> filter) {
            new ArrayList<AchievementState>(AbstractGraph.this.achievementStateList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public World world(String id) {
            World newElement = AbstractGraph.this.graph.createRoot(World.class, this.stash, this.name).a$(World.class);
            newElement.core$().set(newElement, "id", Collections.singletonList(id));
            return newElement;
        }

        public Match match(String id, String worldId, Instant from, String stateName, boolean reboot) {
            Match newElement = AbstractGraph.this.graph.createRoot(Match.class, this.stash, this.name).a$(Match.class);
            newElement.core$().set(newElement, "id", Collections.singletonList(id));
            newElement.core$().set(newElement, "worldId", Collections.singletonList(worldId));
            newElement.core$().set(newElement, "from", Collections.singletonList(from));
            newElement.core$().set(newElement, "stateName", Collections.singletonList(stateName));
            newElement.core$().set(newElement, "reboot", Collections.singletonList(reboot));
            return newElement;
        }

        public Player player(String id, String worldId, List<String> groups) {
            Player newElement = AbstractGraph.this.graph.createRoot(Player.class, this.stash, this.name).a$(Player.class);
            newElement.core$().set(newElement, "id", Collections.singletonList(id));
            newElement.core$().set(newElement, "worldId", Collections.singletonList(worldId));
            newElement.core$().set(newElement, "groups", groups);
            return newElement;
        }

        public Npc npc(String id, String worldId, List<String> groups) {
            Npc newElement = AbstractGraph.this.graph.createRoot(Npc.class, this.stash, this.name).a$(Npc.class);
            newElement.core$().set(newElement, "id", Collections.singletonList(id));
            newElement.core$().set(newElement, "worldId", Collections.singletonList(worldId));
            newElement.core$().set(newElement, "groups", groups);
            return newElement;
        }

        public Item item(String id, String worldId, List<String> groups) {
            Item newElement = AbstractGraph.this.graph.createRoot(Item.class, this.stash, this.name).a$(Item.class);
            newElement.core$().set(newElement, "id", Collections.singletonList(id));
            newElement.core$().set(newElement, "worldId", Collections.singletonList(worldId));
            newElement.core$().set(newElement, "groups", groups);
            return newElement;
        }

        public PlayerState playerState(String playerId) {
            PlayerState newElement = AbstractGraph.this.graph.createRoot(PlayerState.class, this.stash, this.name).a$(PlayerState.class);
            newElement.core$().set(newElement, "playerId", Collections.singletonList(playerId));
            return newElement;
        }

        public Mission mission(String id, Instant expiration, List<String> players, String difficultyName, String typeName, String description, String eventInvolvedName, int maxCount) {
            Mission newElement = AbstractGraph.this.graph.createRoot(Mission.class, this.stash, this.name).a$(Mission.class);
            newElement.core$().set(newElement, "id", Collections.singletonList(id));
            newElement.core$().set(newElement, "expiration", Collections.singletonList(expiration));
            newElement.core$().set(newElement, "players", players);
            newElement.core$().set(newElement, "difficultyName", Collections.singletonList(difficultyName));
            newElement.core$().set(newElement, "typeName", Collections.singletonList(typeName));
            newElement.core$().set(newElement, "description", Collections.singletonList(description));
            newElement.core$().set(newElement, "eventInvolvedName", Collections.singletonList(eventInvolvedName));
            newElement.core$().set(newElement, "maxCount", Collections.singletonList(maxCount));
            return newElement;
        }

        public MissionState missionState(String worldId, String missionId, String playerId, String stateName) {
            MissionState newElement = AbstractGraph.this.graph.createRoot(MissionState.class, this.stash, this.name).a$(MissionState.class);
            newElement.core$().set(newElement, "worldId", Collections.singletonList(worldId));
            newElement.core$().set(newElement, "missionId", Collections.singletonList(missionId));
            newElement.core$().set(newElement, "playerId", Collections.singletonList(playerId));
            newElement.core$().set(newElement, "stateName", Collections.singletonList(stateName));
            return newElement;
        }

        public Achievement achievement(String id, String description, String eventInvolvedName, int maxCount) {
            Achievement newElement = AbstractGraph.this.graph.createRoot(Achievement.class, this.stash, this.name).a$(Achievement.class);
            newElement.core$().set(newElement, "id", Collections.singletonList(id));
            newElement.core$().set(newElement, "description", Collections.singletonList(description));
            newElement.core$().set(newElement, "eventInvolvedName", Collections.singletonList(eventInvolvedName));
            newElement.core$().set(newElement, "maxCount", Collections.singletonList(maxCount));
            return newElement;
        }

        public AchievementState achievementState(String achievementId, String playerId, String stateName) {
            AchievementState newElement = AbstractGraph.this.graph.createRoot(AchievementState.class, this.stash, this.name).a$(AchievementState.class);
            newElement.core$().set(newElement, "achievementId", Collections.singletonList(achievementId));
            newElement.core$().set(newElement, "playerId", Collections.singletonList(playerId));
            newElement.core$().set(newElement, "stateName", Collections.singletonList(stateName));
            return newElement;
        }
    }
}

