/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.CoreGraph;
import io.intino.gamification.core.graph.Entity;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.DoubleLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractEntity
extends Layer
implements Terminal {
    protected String id;
    protected String worldId;
    protected boolean enabled;
    protected double health;
    protected List<String> groups = new ArrayList<String>();

    public AbstractEntity(Node node) {
        super(node);
    }

    public String id() {
        return this.id;
    }

    public String worldId() {
        return this.worldId;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public double health() {
        return this.health;
    }

    public List<String> groups() {
        return this.groups;
    }

    public String groups(int index) {
        return this.groups.get(index);
    }

    public List<String> groups(Predicate<String> predicate) {
        return this.groups().stream().filter(predicate).collect(Collectors.toList());
    }

    public Entity id(String value) {
        this.id = value;
        return (Entity)this;
    }

    public Entity worldId(String value) {
        this.worldId = value;
        return (Entity)this;
    }

    public Entity enabled(boolean value) {
        this.enabled = value;
        return (Entity)this;
    }

    public Entity health(double value) {
        this.health = value;
        return (Entity)this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("id", new ArrayList<String>(Collections.singletonList(this.id)));
        map.put("worldId", new ArrayList<String>(Collections.singletonList(this.worldId)));
        map.put("enabled", new ArrayList<Boolean>(Collections.singletonList(this.enabled)));
        map.put("health", new ArrayList<Double>(Collections.singletonList(this.health)));
        map.put("groups", this.groups);
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("worldId")) {
            this.worldId = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("enabled")) {
            this.enabled = BooleanLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("health")) {
            this.health = DoubleLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("groups")) {
            this.groups = StringLoader.load(values, this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)values.get(0);
        } else if (name.equalsIgnoreCase("worldId")) {
            this.worldId = (String)values.get(0);
        } else if (name.equalsIgnoreCase("enabled")) {
            this.enabled = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("health")) {
            this.health = (Double)values.get(0);
        } else if (name.equalsIgnoreCase("groups")) {
            this.groups = new ArrayList(values);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public CoreGraph graph() {
        return this.core$().graph().as(CoreGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }
    }
}

