/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.graph;

import io.intino.gamification.core.graph.Achievement;
import io.intino.gamification.core.graph.Context;
import io.intino.gamification.core.graph.CoreGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractContext
extends Layer
implements Terminal {
    protected String id;
    protected List<Achievement> achievements = new ArrayList<Achievement>();

    public AbstractContext(Node node) {
        super(node);
    }

    public String id() {
        return this.id;
    }

    public List<Achievement> achievements() {
        return this.achievements;
    }

    public Achievement achievements(int index) {
        return this.achievements.get(index);
    }

    public List<Achievement> achievements(Predicate<Achievement> predicate) {
        return this.achievements().stream().filter(predicate).collect(Collectors.toList());
    }

    public Context id(String value) {
        this.id = value;
        return (Context)this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("id", new ArrayList<String>(Collections.singletonList(this.id)));
        map.put("achievements", this.achievements);
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("achievements")) {
            this.achievements = NodeLoader.load(values, Achievement.class, this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)values.get(0);
        } else if (name.equalsIgnoreCase("achievements")) {
            this.achievements = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Achievement.class)).collect(Collectors.toList());
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public CoreGraph graph() {
        return this.core$().graph().as(CoreGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }
    }
}

