/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter.filter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.mission.CreateMission;
import io.intino.gamification.core.box.events.mission.NewStateMission;
import io.intino.gamification.core.box.mounter.filter.Filter;
import io.intino.gamification.core.box.utils.TimeUtils;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.World;

public class MissionFilter
extends Filter {
    private final World world;
    private Match match;
    private Mission mission;
    private Player player;

    public MissionFilter(CoreBox box, CreateMission event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.difficulty() == null) {
            this.throwMissingEventAttributeException("difficulty");
        }
        if (event.type() == null) {
            this.throwMissingEventAttributeException("type");
        }
        if (event.description() == null) {
            this.throwMissingEventAttributeException("description");
        }
        if (event.eventInvolved() == null) {
            this.throwMissingEventAttributeException("eventInvolved");
        }
        if (event.expiration() != null && event.expiration().isBefore(TimeUtils.currentInstant())) {
            this.throwInvalidAttributeValueException("expiration", String.valueOf(event.expiration()), "The value must be after than now.");
        }
        if (event.maxCount() == null) {
            this.throwMissingEventAttributeException("maxCount");
        }
        if (event.maxCount() <= 0) {
            this.throwInvalidAttributeValueException("maxCount", String.valueOf(event.maxCount()), "The value must be 1 or more.");
        }
        this.world = box.graph().world(event.world());
        this.mission = box.graph().mission(event.id());
        if (this.world != null) {
            this.match = this.world.match();
        }
        this.canMount(this.world != null && this.match != null && this.mission == null);
    }

    public MissionFilter(CoreBox box, NewStateMission event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.player() == null) {
            this.throwMissingEventAttributeException("player");
        }
        if (event.state() == null) {
            this.throwMissingEventAttributeException("state");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.match = this.world.match();
            if (this.match != null) {
                this.mission = box.graph().mission(this.match.missions(), event.id());
                if (this.mission.players().isEmpty() || this.mission.players().contains(event.player())) {
                    this.player = box.graph().player(this.world.players(), event.player());
                }
            }
        }
        this.canMount(this.world != null && this.match != null && this.mission != null && this.player != null);
    }

    public World world() {
        return this.world;
    }

    public Match match() {
        return this.match;
    }

    public Player player() {
        return this.player;
    }

    public Mission mission() {
        return this.mission;
    }
}

