/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter.filter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.match.BeginMatch;
import io.intino.gamification.core.box.events.match.EndMatch;
import io.intino.gamification.core.box.mounter.filter.Filter;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.World;

public class MatchFilter
extends Filter {
    private final World world;
    private Match match;

    public MatchFilter(CoreBox box, BeginMatch event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.reboot() == null) {
            this.throwMissingEventAttributeException("reboot");
        }
        if (event.ts() == null) {
            this.throwMissingEventAttributeException("ts");
        }
        this.world = box.graph().world(event.world());
        this.canMount(this.world != null && this.world.match() == null);
    }

    public MatchFilter(CoreBox box, EndMatch event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.ts() == null) {
            this.throwMissingEventAttributeException("ts");
        }
        this.world = box.graph().world(event.world());
        this.match = box.graph().match(event.id());
        this.canMount(this.world != null && this.match != null && this.world.match().id().equals(this.match.id()));
    }

    public World world() {
        return this.world;
    }

    public Match match() {
        return this.match;
    }
}

