/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter.filter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.entity.CreateItem;
import io.intino.gamification.core.box.events.entity.CreateNpc;
import io.intino.gamification.core.box.events.entity.CreatePlayer;
import io.intino.gamification.core.box.events.entity.DestroyItem;
import io.intino.gamification.core.box.events.entity.DestroyNpc;
import io.intino.gamification.core.box.events.entity.DestroyPlayer;
import io.intino.gamification.core.box.events.entity.DropItem;
import io.intino.gamification.core.box.events.entity.PickUpItem;
import io.intino.gamification.core.box.mounter.filter.Filter;
import io.intino.gamification.core.graph.Item;
import io.intino.gamification.core.graph.Npc;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.World;

public class EntityFilter
extends Filter {
    private final World world;
    private Player player;
    private Npc npc;
    private Item item;

    public EntityFilter(CoreBox box, CreatePlayer event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        this.world = box.graph().world(event.world());
        this.player = box.graph().player(event.id());
        this.canMount(this.player == null && this.world != null);
    }

    public EntityFilter(CoreBox box, CreateNpc event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        this.world = box.graph().world(event.world());
        this.npc = box.graph().npc(event.id());
        this.canMount(this.npc == null && this.world != null);
    }

    public EntityFilter(CoreBox box, CreateItem event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        this.world = box.graph().world(event.world());
        this.item = box.graph().item(event.id());
        if (this.world != null) {
            this.player = box.graph().player(this.world.players(), event.player());
        }
        this.canMount(this.item == null && this.world != null);
    }

    public EntityFilter(CoreBox box, DestroyPlayer event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.destroyStrategy() == null) {
            this.throwMissingEventAttributeException("destroyStrategy");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.player = box.graph().player(this.world.players(), event.id());
        }
        this.canMount(this.player != null && this.world != null);
    }

    public EntityFilter(CoreBox box, DestroyNpc event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.npc = box.graph().npc(this.world.npcs(), event.id());
        }
        this.canMount(this.npc != null && this.world != null);
    }

    public EntityFilter(CoreBox box, DestroyItem event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.item = box.graph().item(this.world.items(), event.id());
        }
        this.canMount(this.item != null && this.world != null);
    }

    public EntityFilter(CoreBox box, PickUpItem event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.player() == null) {
            this.throwMissingEventAttributeException("player");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.item = box.graph().item(this.world.items(), event.id());
            this.player = box.graph().player(this.world.players(), event.player());
        }
        this.canMount(this.player != null && this.item != null);
    }

    public EntityFilter(CoreBox box, DropItem event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.player() == null) {
            this.throwMissingEventAttributeException("player");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.item = box.graph().item(this.world.items(), event.id());
            this.player = box.graph().player(this.world.players(), event.player());
        }
        this.canMount(this.player != null && this.item != null);
    }

    public World world() {
        return this.world;
    }

    public Player player() {
        return this.player;
    }

    public Npc npc() {
        return this.npc;
    }

    public Item item() {
        return this.item;
    }
}

