/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter.filter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.action.Attack;
import io.intino.gamification.core.box.events.action.ChangeScore;
import io.intino.gamification.core.box.events.action.DisableEntity;
import io.intino.gamification.core.box.events.action.EnableEntity;
import io.intino.gamification.core.box.events.action.Heal;
import io.intino.gamification.core.box.events.action.SetHealth;
import io.intino.gamification.core.box.mounter.filter.Filter;
import io.intino.gamification.core.graph.Entity;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.World;

public class ActionFilter
extends Filter {
    private final World world;
    private Entity entity;
    private Match match;

    public ActionFilter(CoreBox box, Attack event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.entityDest() == null) {
            this.throwMissingEventAttributeException("entityDest");
        }
        if (event.damage() == null) {
            this.throwMissingEventAttributeException("damage");
        }
        if (event.damage() < 0.0) {
            this.throwInvalidAttributeValueException("entityDest", String.valueOf(event.damage()), "Value must be 0 or more.");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.entity = box.graph().entity(this.world.entities(), event.entityDest());
        }
        this.canMount(this.entity != null);
    }

    public ActionFilter(CoreBox box, Heal event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.entityDest() == null) {
            this.throwMissingEventAttributeException("entityDest");
        }
        if (event.healedHealth() == null) {
            this.throwMissingEventAttributeException("healedHealth");
        }
        if (event.healedHealth() < 0.0) {
            this.throwInvalidAttributeValueException("healedHealth", String.valueOf(event.healedHealth()), "Value must be 0 or more.");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.entity = box.graph().entity(this.world.entities(), event.entityDest());
        }
        this.canMount(this.entity != null);
    }

    public ActionFilter(CoreBox box, SetHealth event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.entityDest() == null) {
            this.throwMissingEventAttributeException("entityDest");
        }
        if (event.health() == null) {
            this.throwMissingEventAttributeException("health");
        }
        if (event.health() < 0.0 || event.health() > 100.0) {
            this.throwInvalidAttributeValueException("health", String.valueOf(event.health()), "Value must be between 0.0 and 100.0.");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.entity = box.graph().entity(this.world.entities(), event.entityDest());
        }
        this.canMount(this.entity != null);
    }

    public ActionFilter(CoreBox box, ChangeScore event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.entityDest() == null) {
            this.throwMissingEventAttributeException("entityDest");
        }
        if (event.change() == null) {
            this.throwMissingEventAttributeException("change");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.match = this.world.match();
            this.entity = box.graph().player(this.world.players(), event.entityDest());
        }
        this.canMount(this.entity != null);
    }

    public ActionFilter(CoreBox box, EnableEntity event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.entityDest() == null) {
            this.throwMissingEventAttributeException("entityDest");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.entity = box.graph().entity(this.world.entities(), event.id());
        }
        this.canMount(this.entity != null);
    }

    public ActionFilter(CoreBox box, DisableEntity event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.entityDest() == null) {
            this.throwMissingEventAttributeException("entityDest");
        }
        this.world = box.graph().world(event.world());
        if (this.world != null) {
            this.entity = box.graph().entity(this.world.entities(), event.id());
        }
        this.canMount(this.entity != null);
    }

    public World world() {
        return this.world;
    }

    public Entity entity() {
        return this.entity;
    }

    public Match match() {
        return this.match;
    }
}

