/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter.filter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.achievement.AchievementNewState;
import io.intino.gamification.core.box.events.achievement.CreateAchievement;
import io.intino.gamification.core.box.events.achievement.DeleteAchievement;
import io.intino.gamification.core.box.mounter.filter.Filter;
import io.intino.gamification.core.graph.Achievement;
import io.intino.gamification.core.graph.Context;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.World;
import io.intino.gamification.core.model.attributes.AchievementType;

public class AchievementFilter
extends Filter {
    private final Context context;
    private Achievement achievement;
    private Player player;

    public AchievementFilter(CoreBox box, CreateAchievement event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.description() == null) {
            this.throwMissingEventAttributeException("description");
        }
        if (event.type() == null) {
            this.throwMissingEventAttributeException("type");
        }
        if (event.eventInvolved() == null) {
            this.throwMissingEventAttributeException("eventInvolved");
        }
        if (event.maxCount() == null) {
            this.throwMissingEventAttributeException("maxCount");
        }
        if (event.maxCount() <= 0) {
            this.throwInvalidAttributeValueException("maxCount", String.valueOf(event.maxCount()), "The value must be 1 or more.");
        }
        this.context = this.getContextOf(event.world(), event.type());
        this.achievement = box.graph().achievement(event.id());
        this.canMount(this.context != null && this.achievement == null);
    }

    public AchievementFilter(CoreBox box, DeleteAchievement event) {
        super(box);
        if (event.id() == null) {
            this.throwMissingEventAttributeException("id");
        }
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.type() == null) {
            this.throwMissingEventAttributeException("type");
        }
        this.context = this.getContextOf(event.world(), event.type());
        if (this.context != null) {
            this.achievement = box.graph().achievement(this.context.achievements(), event.id());
        }
        this.canMount(this.context != null && this.achievement != null);
    }

    public AchievementFilter(CoreBox box, AchievementNewState event) {
        super(box);
        if (event.world() == null) {
            this.throwMissingEventAttributeException("world");
        }
        if (event.state() == null) {
            this.throwMissingEventAttributeException("state");
        }
        if (event.type() == null) {
            this.throwMissingEventAttributeException("type");
        }
        if (event.player() == null) {
            this.throwMissingEventAttributeException("player");
        }
        this.context = this.getContextOf(event.world(), event.type());
        if (this.context != null) {
            this.achievement = box.graph().achievement(this.context.achievements(), event.id());
            this.player = box.graph().player(this.context.players(), event.player());
        }
        this.canMount(this.context != null && this.achievement != null && this.player != null);
    }

    public Context context() {
        return this.context;
    }

    public Achievement achievement() {
        return this.achievement;
    }

    public Player player() {
        return this.player;
    }

    private Context getContextOf(String worldId, AchievementType type) {
        World world;
        if (type == AchievementType.Global) {
            return this.box.graph().world(worldId);
        }
        if (type == AchievementType.Local && (world = this.box.graph().world(worldId)) != null) {
            return world.match();
        }
        return null;
    }
}

