/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.EventBuilder;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.events.world.CreateWorld;
import io.intino.gamification.core.box.events.world.DestroyWorld;
import io.intino.gamification.core.box.mounter.Mounter;
import io.intino.gamification.core.box.mounter.filter.WorldFilter;
import io.intino.gamification.core.graph.World;
import io.intino.magritte.framework.Layer;

public class WorldMounter
extends Mounter {
    public WorldMounter(CoreBox box) {
        super(box);
    }

    @Override
    public void mount(GamificationEvent event) {
        if (event instanceof CreateWorld) {
            this.handle((CreateWorld)event);
        } else if (event instanceof DestroyWorld) {
            this.handle((DestroyWorld)event);
        }
    }

    private void handle(CreateWorld event) {
        WorldFilter filter = new WorldFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        this.box.graph().world(event).save$();
    }

    private void handle(DestroyWorld event) {
        WorldFilter filter = new WorldFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        World world = filter.world();
        world.achievements().forEach(a -> this.box.terminal().feed((GamificationEvent)EventBuilder.deleteAchievement(a.id())));
        world.players().forEach(e -> this.box.terminal().feed((GamificationEvent)EventBuilder.destroyPlayer(world.id(), e.id())));
        world.npcs().forEach(e -> this.box.terminal().feed((GamificationEvent)EventBuilder.destroyNpc(world.id(), e.id())));
        world.items().forEach(e -> this.box.terminal().feed((GamificationEvent)EventBuilder.destroyItem(world.id(), e.id())));
        this.box.graph().matchesIn(world).forEach(ma -> {
            ma.missions().forEach(mi -> {
                this.box.graph().missionState(mi.id()).forEach(Layer::delete$);
                mi.delete$();
            });
            ma.achievements().forEach(a -> this.box.terminal().feed((GamificationEvent)EventBuilder.deleteAchievement(a.id())));
            ma.playersState().forEach(ps -> {
                ps.missionState().forEach(Layer::delete$);
                ps.achievements().forEach(Layer::delete$);
                ps.delete$();
            });
            ma.delete$();
        });
        world.delete$();
    }
}

