/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.mounter.AchievementMounter;
import io.intino.gamification.core.box.mounter.ActionMounter;
import io.intino.gamification.core.box.mounter.EntityMounter;
import io.intino.gamification.core.box.mounter.MatchMounter;
import io.intino.gamification.core.box.mounter.MissionMounter;
import io.intino.gamification.core.box.mounter.Mounter;
import io.intino.gamification.core.box.mounter.WorldMounter;
import java.util.HashMap;
import java.util.Map;

public class Mounters {
    private final CoreBox box;
    private static Map<Class<? extends Mounter>, Mounter> builder = new HashMap<Class<? extends Mounter>, Mounter>();

    public Mounters(CoreBox box) {
        this.box = box;
        this.buildMounters();
    }

    private void buildMounters() {
        builder.put(AchievementMounter.class, new AchievementMounter(this.box));
        builder.put(EntityMounter.class, new EntityMounter(this.box));
        builder.put(ActionMounter.class, new ActionMounter(this.box));
        builder.put(MatchMounter.class, new MatchMounter(this.box));
        builder.put(MissionMounter.class, new MissionMounter(this.box));
        builder.put(WorldMounter.class, new WorldMounter(this.box));
    }

    public <T extends Mounter> T mounter(Class<T> clazz) {
        return (T)builder.get(clazz);
    }
}

