/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.EventBuilder;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.events.mission.CreateMission;
import io.intino.gamification.core.box.events.mission.NewStateMission;
import io.intino.gamification.core.box.mounter.Mounter;
import io.intino.gamification.core.box.mounter.filter.MissionFilter;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.MissionState;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.PlayerState;
import io.intino.gamification.core.graph.World;

public class MissionMounter
extends Mounter {
    public MissionMounter(CoreBox box) {
        super(box);
    }

    @Override
    public void mount(GamificationEvent event) {
        if (event instanceof CreateMission) {
            this.handle((CreateMission)event);
        }
        if (event instanceof NewStateMission) {
            this.handle((NewStateMission)event);
        }
    }

    private void handle(CreateMission event) {
        MissionFilter filter = new MissionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Match match = filter.match();
        Mission mission = this.box.graph().mission(event);
        match.missions().add(mission);
        match.save$();
        mission.save$();
    }

    private void handle(NewStateMission event) {
        MissionState missionState;
        MissionFilter filter = new MissionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        World world = filter.world();
        Match match = filter.match();
        Player player = filter.player();
        Mission mission = filter.mission();
        PlayerState playerState = this.box.graph().playerState(match.playersState(), player.id());
        if (playerState == null) {
            playerState = this.box.graph().playerState(player.id());
            match.playersState().add(playerState);
        }
        if ((missionState = this.box.graph().missionState(playerState.missionState(), mission.id())) == null || missionState.state().equals((Object)io.intino.gamification.core.model.attributes.MissionState.Pending)) {
            if (missionState == null) {
                missionState = this.box.graph().missionState(event, world.id(), mission.id(), player.id());
                playerState.missionState().add(missionState);
            } else {
                missionState.state(event.state());
            }
            int score = this.box.engineConfig().missionScoreMapper.get().score(player, mission, missionState.state());
            this.box.terminal().feed((GamificationEvent)EventBuilder.changeScore(world.id(), player.id(), score));
        }
        match.save$();
        playerState.save$();
        missionState.save$();
    }
}

