/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.events.match.BeginMatch;
import io.intino.gamification.core.box.events.match.EndMatch;
import io.intino.gamification.core.box.helper.MissionHelper;
import io.intino.gamification.core.box.mounter.Mounter;
import io.intino.gamification.core.box.mounter.filter.MatchFilter;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.World;
import io.intino.gamification.core.model.attributes.MatchState;

public class MatchMounter
extends Mounter {
    public MatchMounter(CoreBox box) {
        super(box);
    }

    @Override
    public void mount(GamificationEvent event) {
        if (event instanceof BeginMatch) {
            this.handle((BeginMatch)event);
        } else if (event instanceof EndMatch) {
            this.handle((EndMatch)event);
        }
    }

    private void handle(BeginMatch event) {
        MatchFilter filter = new MatchFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        World world = filter.world();
        Match match = this.box.graph().match(event, world.id());
        world.match(match);
        if (event.expiration() != null) {
            match.to(event.expiration());
        }
        world.save$();
        match.save$();
    }

    private void handle(EndMatch event) {
        MatchFilter filter = new MatchFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        World world = filter.world();
        Match match = filter.match();
        this.box.helper(MissionHelper.class).failMissions(world, Mission::isActive);
        world.match(null);
        match.to(event.ts()).state(MatchState.Finished);
        world.save$();
        match.save$();
    }
}

