/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.events.action.Attack;
import io.intino.gamification.core.box.events.action.ChangeScore;
import io.intino.gamification.core.box.events.action.DisableEntity;
import io.intino.gamification.core.box.events.action.EnableEntity;
import io.intino.gamification.core.box.events.action.Heal;
import io.intino.gamification.core.box.events.action.SetHealth;
import io.intino.gamification.core.box.mounter.Mounter;
import io.intino.gamification.core.box.mounter.filter.ActionFilter;
import io.intino.gamification.core.box.utils.MathUtils;
import io.intino.gamification.core.graph.Entity;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.PlayerState;

public class ActionMounter
extends Mounter {
    public ActionMounter(CoreBox box) {
        super(box);
    }

    @Override
    public void mount(GamificationEvent event) {
        if (event instanceof Attack) {
            this.handle((Attack)event);
        } else if (event instanceof Heal) {
            this.handle((Heal)event);
        } else if (event instanceof SetHealth) {
            this.handle((SetHealth)event);
        } else if (event instanceof ChangeScore) {
            this.handle((ChangeScore)event);
        } else if (event instanceof EnableEntity) {
            this.handle((EnableEntity)event);
        } else if (event instanceof DisableEntity) {
            this.handle((DisableEntity)event);
        }
    }

    private void handle(Attack event) {
        ActionFilter filter = new ActionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Entity entity = filter.entity();
        Double newHealth = this.box.engineConfig().healthListener.get().onValueChange(entity, entity.health(), entity.health() - event.damage());
        entity.health(MathUtils.clamp(newHealth, 0.0, 100.0));
        entity.save$();
    }

    private void handle(Heal event) {
        ActionFilter filter = new ActionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Entity entity = filter.entity();
        Double newHealth = this.box.engineConfig().healthListener.get().onValueChange(entity, entity.health(), entity.health() + event.healedHealth());
        entity.health(newHealth);
        entity.save$();
    }

    private void handle(SetHealth event) {
        ActionFilter filter = new ActionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Entity entity = filter.entity();
        Double newHealth = this.box.engineConfig().healthListener.get().onValueChange(entity, entity.health(), event.health());
        entity.health(newHealth);
        entity.save$();
    }

    private void handle(ChangeScore event) {
        ActionFilter filter = new ActionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Match match = filter.match();
        Player player = (Player)filter.entity();
        Integer newScore = this.box.engineConfig().scoreListener.get().onValueChange(player, player.score(), player.score() + event.change());
        player.score(newScore);
        if (match != null) {
            this.changeMatchRelativeScore(match, player, event.change());
        }
        player.save$();
    }

    private void handle(EnableEntity event) {
        ActionFilter filter = new ActionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Entity entity = filter.entity();
        Boolean newEnableState = this.box.engineConfig().enableListener.get().onValueChange(entity, entity.enabled(), true);
        entity.enabled(newEnableState);
        entity.save$();
    }

    private void handle(DisableEntity event) {
        ActionFilter filter = new ActionFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Entity entity = filter.entity();
        Boolean newEnableState = this.box.engineConfig().enableListener.get().onValueChange(entity, entity.enabled(), false);
        entity.enabled(newEnableState);
        entity.save$();
    }

    private void changeMatchRelativeScore(Match match, Player player, int shift) {
        PlayerState playerState = this.box.graph().playerState(match.playersState(), player.id());
        if (playerState == null) {
            playerState = this.box.graph().playerState(player.id());
            match.playersState().add(playerState);
            match.save$();
        }
        playerState.score(playerState.score() + shift).save$();
    }
}

