/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.mounter;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.events.achievement.AchievementNewState;
import io.intino.gamification.core.box.events.achievement.CreateAchievement;
import io.intino.gamification.core.box.events.achievement.DeleteAchievement;
import io.intino.gamification.core.box.mounter.Mounter;
import io.intino.gamification.core.box.mounter.filter.AchievementFilter;
import io.intino.gamification.core.graph.Achievement;
import io.intino.gamification.core.graph.Context;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.PlayerState;
import io.intino.gamification.core.graph.World;
import io.intino.gamification.core.model.attributes.AchievementState;
import io.intino.magritte.framework.Layer;

public class AchievementMounter
extends Mounter {
    public AchievementMounter(CoreBox box) {
        super(box);
    }

    @Override
    public void mount(GamificationEvent event) {
        if (event instanceof CreateAchievement) {
            this.handle((CreateAchievement)event);
        } else if (event instanceof DeleteAchievement) {
            this.handle((DeleteAchievement)event);
        } else if (event instanceof AchievementNewState) {
            this.handle((AchievementNewState)event);
        }
    }

    private void handle(CreateAchievement event) {
        AchievementFilter filter = new AchievementFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Context context = filter.context();
        Achievement achievement = this.box.graph().achievement(event);
        context.achievements().add(achievement);
        context.save$();
        achievement.save$();
    }

    private void handle(DeleteAchievement event) {
        AchievementFilter filter = new AchievementFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Context context = filter.context();
        Achievement achievement = filter.achievement();
        context.achievements().remove(achievement);
        this.box.graph().achievementState(achievement.id()).forEach(Layer::delete$);
        context.save$();
        achievement.delete$();
    }

    private void handle(AchievementNewState event) {
        AchievementFilter filter = new AchievementFilter(this.box, event);
        if (!filter.canMount()) {
            return;
        }
        Context context = filter.context();
        Achievement achievement = filter.achievement();
        Player player = filter.player();
        io.intino.gamification.core.graph.AchievementState achievementState = this.box.graph().achievementStateOf(achievement.id(), player.id());
        if (achievementState == null) {
            achievementState = this.box.graph().achievementState(event, achievement.id(), player.id());
            if (context instanceof World) {
                player.achievements().add(achievementState);
                player.save$();
            } else {
                PlayerState playerState = this.box.graph().playerState(((Match)context).playersState(), player.id());
                if (playerState == null) {
                    playerState = this.box.graph().playerState(player.id());
                }
                playerState.achievements().add(achievementState);
                playerState.save$();
            }
        } else if (achievementState.state().equals((Object)AchievementState.Pending)) {
            achievementState.state(event.state());
        }
        achievementState.save$();
    }
}

