/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.helper;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.EventBuilder;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.helper.Helper;
import io.intino.gamification.core.graph.AbstractEntity;
import io.intino.gamification.core.graph.Match;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.Player;
import io.intino.gamification.core.graph.World;
import io.intino.gamification.core.model.attributes.MissionState;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MissionHelper
extends Helper {
    public MissionHelper(CoreBox box) {
        super(box);
    }

    public void failMissions(World world, Predicate<Mission> missionFilter) {
        Match match = world.match();
        List<Mission> missionsToExpire = match.missions().stream().filter(missionFilter).collect(Collectors.toList());
        missionsToExpire.forEach(m -> match.players().stream().filter(p -> m.players().contains(p.id())).filter(AbstractEntity::enabled).forEach(p -> this.failMissions(world, (Mission)m, (Player)p)));
    }

    private void failMissions(World world, Mission mission, Player player) {
        this.box.terminal().feed((GamificationEvent)EventBuilder.newStateMission(world.id(), mission.id(), player.id(), MissionState.Failed));
    }
}

