/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.events;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.events.achievement.AchievementNewState;
import io.intino.gamification.core.box.events.achievement.CreateAchievement;
import io.intino.gamification.core.box.events.achievement.DeleteAchievement;
import io.intino.gamification.core.box.events.action.Action;
import io.intino.gamification.core.box.events.action.Attack;
import io.intino.gamification.core.box.events.action.ChangeScore;
import io.intino.gamification.core.box.events.action.DisableEntity;
import io.intino.gamification.core.box.events.action.EnableEntity;
import io.intino.gamification.core.box.events.action.Heal;
import io.intino.gamification.core.box.events.action.SetHealth;
import io.intino.gamification.core.box.events.entity.CreateItem;
import io.intino.gamification.core.box.events.entity.CreateNpc;
import io.intino.gamification.core.box.events.entity.CreatePlayer;
import io.intino.gamification.core.box.events.entity.DestroyItem;
import io.intino.gamification.core.box.events.entity.DestroyNpc;
import io.intino.gamification.core.box.events.entity.DestroyPlayer;
import io.intino.gamification.core.box.events.entity.DropItem;
import io.intino.gamification.core.box.events.entity.PickUpItem;
import io.intino.gamification.core.box.events.match.BeginMatch;
import io.intino.gamification.core.box.events.match.EndMatch;
import io.intino.gamification.core.box.events.mission.CreateMission;
import io.intino.gamification.core.box.events.mission.NewStateMission;
import io.intino.gamification.core.box.events.world.CreateWorld;
import io.intino.gamification.core.box.events.world.DestroyWorld;
import io.intino.gamification.core.box.mounter.AchievementMounter;
import io.intino.gamification.core.box.mounter.ActionMounter;
import io.intino.gamification.core.box.mounter.EntityMounter;
import io.intino.gamification.core.box.mounter.MatchMounter;
import io.intino.gamification.core.box.mounter.MissionMounter;
import io.intino.gamification.core.box.mounter.WorldMounter;
import io.intino.gamification.core.model.Component;
import io.intino.gamification.core.model.Match;
import io.intino.gamification.core.model.attributes.AchievementType;

public class Terminal {
    private final CoreBox box;

    public Terminal(CoreBox box) {
        this.box = box;
    }

    public Component feed(GamificationEvent event) {
        if (event instanceof AchievementNewState) {
            return this.feed((AchievementNewState)event);
        }
        if (event instanceof CreateAchievement) {
            return this.feed((CreateAchievement)event);
        }
        if (event instanceof DeleteAchievement) {
            return this.feed((DeleteAchievement)event);
        }
        if (event instanceof Action) {
            return this.feed((Action)event);
        }
        if (event instanceof Attack) {
            return this.feed((Attack)event);
        }
        if (event instanceof DisableEntity) {
            return this.feed((DisableEntity)event);
        }
        if (event instanceof EnableEntity) {
            return this.feed((EnableEntity)event);
        }
        if (event instanceof Heal) {
            return this.feed((Heal)event);
        }
        if (event instanceof SetHealth) {
            return this.feed((SetHealth)event);
        }
        if (event instanceof ChangeScore) {
            return this.feed((ChangeScore)event);
        }
        if (event instanceof CreatePlayer) {
            return this.feed((CreatePlayer)event);
        }
        if (event instanceof CreateNpc) {
            return this.feed((CreateNpc)event);
        }
        if (event instanceof CreateItem) {
            return this.feed((CreateItem)event);
        }
        if (event instanceof DestroyPlayer) {
            return this.feed((DestroyPlayer)event);
        }
        if (event instanceof DestroyNpc) {
            return this.feed((DestroyNpc)event);
        }
        if (event instanceof DestroyItem) {
            return this.feed((DestroyItem)event);
        }
        if (event instanceof PickUpItem) {
            return this.feed((PickUpItem)event);
        }
        if (event instanceof DropItem) {
            return this.feed((DropItem)event);
        }
        if (event instanceof BeginMatch) {
            return this.feed((BeginMatch)event);
        }
        if (event instanceof EndMatch) {
            return this.feed((EndMatch)event);
        }
        if (event instanceof CreateMission) {
            return this.feed((CreateMission)event);
        }
        if (event instanceof NewStateMission) {
            return this.feed((NewStateMission)event);
        }
        if (event instanceof CreateWorld) {
            return this.feed((CreateWorld)event);
        }
        if (event instanceof DestroyWorld) {
            return this.feed((DestroyWorld)event);
        }
        return null;
    }

    private Component feed(AchievementNewState event) {
        this.box.mounter(AchievementMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(CreateAchievement event) {
        this.box.mounter(AchievementMounter.class).handle((GamificationEvent)event);
        if (event.type() == AchievementType.Global) {
            return this.box.engineDatamart().globalAchievement(event.world(), event.id());
        }
        if (event.type() == AchievementType.Local) {
            return this.box.engineDatamart().localAchievement(event.world(), event.id());
        }
        return null;
    }

    private Component feed(DeleteAchievement event) {
        this.box.mounter(AchievementMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(Action event) {
        this.box.mounter(ActionMounter.class).handle(event);
        return null;
    }

    private Component feed(Attack event) {
        this.box.mounter(ActionMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(DisableEntity event) {
        this.box.mounter(ActionMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(EnableEntity event) {
        this.box.mounter(ActionMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(Heal event) {
        this.box.mounter(ActionMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(SetHealth event) {
        this.box.mounter(ActionMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(ChangeScore event) {
        this.box.mounter(ActionMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(CreatePlayer event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return this.box.engineDatamart().player(event.world(), event.id());
    }

    private Component feed(CreateNpc event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return this.box.engineDatamart().npc(event.world(), event.id());
    }

    private Component feed(CreateItem event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return this.box.engineDatamart().item(event.world(), event.id());
    }

    private Component feed(DestroyPlayer event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(DestroyNpc event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(DestroyItem event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(PickUpItem event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(DropItem event) {
        this.box.mounter(EntityMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(BeginMatch event) {
        this.box.mounter(MatchMounter.class).handle((GamificationEvent)event);
        Match match = this.box.engineDatamart().match(event.world());
        return match.from().equals(event.ts()) ? match : null;
    }

    private Component feed(EndMatch event) {
        this.box.mounter(MatchMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(CreateMission event) {
        this.box.mounter(MissionMounter.class).handle((GamificationEvent)event);
        return this.box.engineDatamart().mission(event.world(), event.id());
    }

    private Component feed(NewStateMission event) {
        this.box.mounter(MissionMounter.class).handle((GamificationEvent)event);
        return null;
    }

    private Component feed(CreateWorld event) {
        this.box.mounter(WorldMounter.class).handle((GamificationEvent)event);
        return this.box.engineDatamart().world(event.id());
    }

    private Component feed(DestroyWorld event) {
        this.box.mounter(WorldMounter.class).handle((GamificationEvent)event);
        return null;
    }
}

