/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.events;

import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.events.achievement.AchievementNewState;
import io.intino.gamification.core.box.events.achievement.CreateAchievement;
import io.intino.gamification.core.box.events.achievement.DeleteAchievement;
import io.intino.gamification.core.box.events.action.Action;
import io.intino.gamification.core.box.events.action.Attack;
import io.intino.gamification.core.box.events.action.ChangeScore;
import io.intino.gamification.core.box.events.action.DisableEntity;
import io.intino.gamification.core.box.events.action.EnableEntity;
import io.intino.gamification.core.box.events.action.Heal;
import io.intino.gamification.core.box.events.action.SetHealth;
import io.intino.gamification.core.box.events.entity.CreateItem;
import io.intino.gamification.core.box.events.entity.CreateNpc;
import io.intino.gamification.core.box.events.entity.CreatePlayer;
import io.intino.gamification.core.box.events.entity.DestroyItem;
import io.intino.gamification.core.box.events.entity.DestroyNpc;
import io.intino.gamification.core.box.events.entity.DestroyPlayer;
import io.intino.gamification.core.box.events.entity.DropItem;
import io.intino.gamification.core.box.events.entity.PickUpItem;
import io.intino.gamification.core.box.events.match.BeginMatch;
import io.intino.gamification.core.box.events.match.EndMatch;
import io.intino.gamification.core.box.events.mission.CreateMission;
import io.intino.gamification.core.box.events.mission.NewStateMission;
import io.intino.gamification.core.box.events.world.CreateWorld;
import io.intino.gamification.core.box.events.world.DestroyWorld;
import java.util.Arrays;

public enum EventType {
    AchievementNewState(AchievementNewState.class),
    CreateAchievement(CreateAchievement.class),
    DeleteAchievement(DeleteAchievement.class),
    Action(Action.class),
    Attack(Attack.class),
    DisableEntity(DisableEntity.class),
    EnableEntity(EnableEntity.class),
    Heal(Heal.class),
    SetHealth(SetHealth.class),
    ChangeScore(ChangeScore.class),
    CreateItem(CreateItem.class),
    CreateNpc(CreateNpc.class),
    CreatePlayer(CreatePlayer.class),
    DestroyEntity(DestroyItem.class),
    DestroyNpc(DestroyNpc.class),
    DestroyPlayer(DestroyPlayer.class),
    DropItem(DropItem.class),
    PickUpItem(PickUpItem.class),
    BeginMatch(BeginMatch.class),
    EndMatch(EndMatch.class),
    CreateMission(CreateMission.class),
    NewStateMission(NewStateMission.class),
    CreateWorld(CreateWorld.class),
    DestroyWorld(DestroyWorld.class);

    private final Class<? extends GamificationEvent> clazz;

    private EventType(Class<? extends GamificationEvent> clazz) {
        this.clazz = clazz;
    }

    public Class<? extends GamificationEvent> clazz() {
        return this.clazz;
    }

    public static EventType get(Class<? extends GamificationEvent> clazz) {
        return Arrays.stream(EventType.values()).filter(et -> et.clazz().equals(clazz)).findFirst().orElse(null);
    }

    public String clazzName() {
        return this.clazz.getSimpleName();
    }
}

