/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.configurator;

import io.intino.alexandria.event.Event;
import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.checkers.MatchTimerChecker;
import io.intino.gamification.core.box.checkers.MissionTimerChecker;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.listeners.EventProcessListener;
import io.intino.gamification.core.box.utils.TimeUtils;
import io.intino.gamification.core.exception.InvalidAttributeValueException;
import io.intino.gamification.core.model.Component;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public class GameLoopConfigurator {
    private final CoreBox box;
    private final Queue<GamificationEventWrapper<? extends GamificationEvent, ? extends Component>> eventQueue;
    private Timer timer;
    private int amount;
    private TimeUtils.Scale scale;

    public GameLoopConfigurator(CoreBox box) {
        this.box = box;
        this.eventQueue = new PriorityQueue<GamificationEventWrapper>(Comparator.comparing(w -> ((Event)w.event()).ts()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends GamificationEvent, S extends Component> void enqueue(T event) {
        Queue<GamificationEventWrapper<? extends GamificationEvent, ? extends Component>> queue = this.eventQueue;
        synchronized (queue) {
            GamificationEventWrapper wrapper = new GamificationEventWrapper(event);
            this.eventQueue.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends GamificationEvent, S extends Component> void enqueue(T event, EventProcessListener<S> listener) {
        Queue<GamificationEventWrapper<? extends GamificationEvent, ? extends Component>> queue = this.eventQueue;
        synchronized (queue) {
            GamificationEventWrapper<T, S> wrapper = new GamificationEventWrapper<T, S>(event, listener);
            this.eventQueue.add(wrapper);
        }
    }

    public void schedule(int amount, TimeUtils.Scale scale) {
        if (amount <= 0) {
            throw new InvalidAttributeValueException("amount", String.valueOf(amount), "The value must be 1 or more.");
        }
        if (scale == null) {
            throw new InvalidAttributeValueException("scale", "null", "The value can't be null.");
        }
        this.amount = amount;
        this.scale = scale;
        this.scheduleGameLoop(TimeUtils.getMillisOf(scale, amount));
    }

    private void scheduleGameLoop(long millis) {
        if (this.timer != null) {
            this.stopPreviousLoop();
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new GameLoopUpdate(), 0L, millis);
    }

    private void stopPreviousLoop() {
        this.timer.cancel();
        this.timer.purge();
    }

    private void runCheckers() {
        this.box.checker(MissionTimerChecker.class).check(this.amount, this.scale);
        this.box.checker(MatchTimerChecker.class).check(this.amount, this.scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedEvents() {
        Queue<GamificationEventWrapper<? extends GamificationEvent, ? extends Component>> queue = this.eventQueue;
        synchronized (queue) {
            while (!this.eventQueue.isEmpty()) {
                GamificationEventWrapper<? extends GamificationEvent, ? extends Component> wrapper = this.eventQueue.poll();
                if (wrapper == null) continue;
                Component component = this.box.terminal().feed(wrapper.event());
                if (wrapper.listener() == null || component == null) continue;
                wrapper.listener().process(component);
            }
        }
    }

    public static class GamificationEventWrapper<T extends GamificationEvent, S extends Component> {
        private final T event;
        private final EventProcessListener<S> listener;

        public GamificationEventWrapper(T event) {
            this.event = event;
            this.listener = null;
        }

        public GamificationEventWrapper(T event, EventProcessListener<S> listener) {
            this.event = event;
            this.listener = listener;
        }

        public T event() {
            return this.event;
        }

        public EventProcessListener<S> listener() {
            return this.listener;
        }
    }

    private class GameLoopUpdate
    extends TimerTask {
        private GameLoopUpdate() {
        }

        @Override
        public void run() {
            GameLoopConfigurator.this.runCheckers();
            GameLoopConfigurator.this.feedEvents();
        }
    }
}

