/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.checkers;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.checkers.Checker;
import io.intino.gamification.core.box.helper.MissionHelper;
import io.intino.gamification.core.box.utils.TimeUtils;
import io.intino.gamification.core.graph.World;
import java.time.Instant;

public class MissionTimerChecker
extends Checker {
    private Instant from;
    private Instant to;

    public MissionTimerChecker(CoreBox box) {
        super(box);
    }

    public void check(int amount, TimeUtils.Scale scale) {
        this.to = TimeUtils.currentInstant();
        this.from = TimeUtils.previousInstant(this.to, scale, amount);
        MissionHelper helper = this.box.helper(MissionHelper.class);
        this.box.graph().worldList().stream().filter(w -> w.match() != null).forEach(w -> helper.failMissions((World)w, m -> m.expiration() != null && TimeUtils.instantIsInRange(m.expiration(), this.from, this.to)));
    }
}

