/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core.box.checkers;

import io.intino.gamification.core.box.CoreBox;
import io.intino.gamification.core.box.checkers.CheckResult;
import io.intino.gamification.core.box.checkers.Checker;
import io.intino.gamification.core.box.checkers.entries.MissionEntry;
import io.intino.gamification.core.box.events.EventBuilder;
import io.intino.gamification.core.box.events.GamificationEvent;
import io.intino.gamification.core.box.helper.MissionStateHelper;
import io.intino.gamification.core.graph.Mission;
import io.intino.gamification.core.graph.MissionState;
import io.intino.gamification.core.graph.Player;
import java.util.List;

public class MissionChecker
extends Checker {
    public MissionChecker(CoreBox box) {
        super(box);
    }

    public void checkMissions(GamificationEvent event) {
        List<MissionEntry> missionEntries = this.box.graph().mission(event.getClass());
        missionEntries.forEach(me -> me.players().forEach(p -> this.checkMission(event, me.mission(), me.world(), (Player)p)));
    }

    private void checkMission(GamificationEvent event, Mission mission, String worldId, Player player) {
        CheckResult checkResult = mission.check(event, player);
        if (checkResult == CheckResult.Skip) {
            return;
        }
        MissionState missionState = this.box.helper(MissionStateHelper.class).getOrCreateMissionState(mission, worldId, player);
        if (checkResult == CheckResult.Progress) {
            missionState.count(missionState.count() + 1).save$();
            if (missionState.count() >= mission.maxCount()) {
                this.box.terminal().feed((GamificationEvent)EventBuilder.newStateMission(worldId, mission.id(), player.id(), io.intino.gamification.core.model.attributes.MissionState.Completed));
            }
        } else if (checkResult == CheckResult.Cancel) {
            this.box.terminal().feed((GamificationEvent)EventBuilder.newStateMission(worldId, mission.id(), player.id(), io.intino.gamification.core.model.attributes.MissionState.Cancelled));
        }
    }
}

